package com.northpool.service.dao;

import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.config.IBinaryContent;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;
import org.bson.conversions.Bson;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AbstractMongoGridFSDao<T extends IBinaryContent & Idable<String> & IDocumentAble & Jsonable, Builder extends JsonableBuilder<T> & DocumentableBuilder<T>> implements IMongoDao<T> {

    protected MongoDatabase database;

    protected String idFieldName;

    protected GridFSBucket bucket;

    public String bucketName;

    protected Builder beanBuilder;


    public AbstractMongoGridFSDao(MongoDatabase mongoDatabase, String bucketName, String idFieldName, Builder builder) {
        this.database = mongoDatabase;
        this.idFieldName = idFieldName;
        this.bucketName = bucketName;
        this.bucket = GridFSBuckets.create(mongoDatabase, bucketName);
        this.beanBuilder = builder;

    }

    public List<T> find(Bson filter) {
        GridFSFindIterable it = bucket.find(filter);
        MongoCursor<GridFSFile> cursor = it.iterator();
        List<T> list = new ArrayList<>();
        while (cursor.hasNext()){
            GridFSFile f = cursor.next();
            Document doc = f.getMetadata();
            T bean = null;
            try {
                bean = beanBuilder.fromDocument(doc);
            } catch (Exception e) {
                e.printStackTrace();
            }
            list.add(bean);
        }
        return list;
    }

    @Override
    public Long count(Bson filter) {
        return null;
    }

    @Override
    public Boolean exists(String id) {
        return this.findone(id) != null;
    }

    public T findone(String id) {
        GridFSFindIterable it = bucket.find(new Document(this.idFieldName, id));
        GridFSFile f = it.first();
        if (f != null){
            Document doc = f.getMetadata();
            T bean = null;
            try {
                bean = beanBuilder.fromDocument(doc);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return bean;

        }
        return null;
    }

    @Override
    public T findone(Bson filter) {
        GridFSFindIterable it = bucket.find(filter);
        GridFSFile f = it.first();
        if (f != null){
            Document doc = f.getMetadata();
            T bean = null;
            try {
                bean = beanBuilder.fromDocument(doc);
            } catch (Exception e) {
                e.printStackTrace();
            }
            return bean;

        }
        return null;
    }


    protected GridFSFile findoneGF(Bson filter){
        GridFSFindIterable it = bucket.find(filter);
        return it.first();
    }

    @Override
    public void deleteone(String id) {
        GridFSFile fontgf = this.findoneGF(new Document(this.idFieldName, id));
        if (fontgf != null){
            bucket.delete(fontgf.getObjectId());
        }
    }

    @Override
    public void updateOne(String id, T bean) {
        this.deleteone(bean.getId());
        this.insertOne(bean);
    }

    @Override
    public void insertOne(T bean) {
        ByteArrayInputStream bin = new ByteArrayInputStream(bean.getContent());
        GridFSUploadOptions options = new GridFSUploadOptions().chunkSizeBytes(358400).metadata(bean.toDocument());
        bucket.uploadFromStream(bean.getId(), bin, options);
    }

    public byte[] getContent(Bson filter){
        GridFSFindIterable it = bucket.find(filter);
        GridFSFile file = it.first();
        byte[] content = new byte[0];
        try (ByteArrayOutputStream out = new ByteArrayOutputStream()){
            bucket.downloadToStream(file.getObjectId(), out);
            content = out.toByteArray();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }


}
