package com.northpool.service.dao.data_service;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.DataServiceBuilder;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.dao.AbtractServiceZkDao;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;

import java.util.List;

public class DataServiceZkDao extends AbtractServiceZkDao<IDataService, DataServiceBuilder> {
    public DataServiceZkDao(String idFieldName, DataServiceBuilder beanBuilder, QueryHashTableHeap<String, IDataService> table, Client client, String managerRoot, Boolean readOnly) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
    }

    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, IDataService dataService)throws Exception {
        // TODO Auto-generated method stub
        super.AddExtendsInfo2BeanNode(path, iList, transaction, dataService);
        CuratorOp createOp = transaction.create().forPath(path + "/read_only", dataService.getReadOnly().toString().getBytes());
        iList.add(createOp);
    }
}
