/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service;

import com.northpool.commons.classloader.MemoryClassLoader;
import com.northpool.commons.reflect.Reflect;
import com.northpool.commons.util.FileUtil;
import com.northpool.service.client.Client;
import com.northpool.service.netty.websocket.WebSocketServer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientMain {
    MemoryClassLoader loader;
    Object client;
    Class clientClass;

    public ClientMain(String path, Object[] info) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String curPath = path;
        this.loader = new MemoryClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        for (int i = 0; i < info.length / 2; ++i) {
            this.loader.loadJar((String)info[i * 2], (byte[])info[i * 2 + 1]);
        }
        Reflect.setClassLoader((ClassLoader)this.loader);
        System.setProperty("APP_HOME", curPath);
    }

    public Object init(String mongoUri, String zkAddress, String mapserverUrl, Integer tcpPort) throws Exception {
        Thread.currentThread().setContextClassLoader(this.loader);
        this.clientClass = this.loader.loadClass("com.northpool.service.client.Client");
        Constructor constructor = this.clientClass.getDeclaredConstructor(String.class, String.class, String.class);
        this.client = constructor.newInstance(mongoUri, zkAddress, mapserverUrl);
        new WebSocketServer((Client)this.client).bind(tcpPort);
        return this.client;
    }

    public Object getTextureManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTextureManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getVectorServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getVectorServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getDataSourcesManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getDataSourcesManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getDataServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getDataServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getStyleManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getStyleManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getFontManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getFontManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getTileDataCellManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTileDataCellManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public static void main(String[] aaa) throws Exception, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        byte[] b = FileUtil.File2byte((String)"C:\\test\\vector_cut_cell-0.0.4-SNAPSHOT.jar");
        ClientMain nodeJavaBridge = new ClientMain("C:\\gitcode\\mapserverManager3.x\\service-client\\target\\classes", new Object[]{"VectorService-1.2.5.1.jar", b});
        nodeJavaBridge.init("mongodb://127.0.0.1:27017/osmxuyuan", "127.0.0.1:2181", "http://127.0.0.1:81/mapserver", 20001);
        System.out.println(nodeJavaBridge.getTileDataCellManager());
    }
}

