/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.client;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.northpool.resources.utils.MongoClientURI;
import com.northpool.service.manager.ManagerFactory;
import com.northpool.service.manager.cell.ITileDataCellManager;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.exception.ManagerDuplicateException;
import com.northpool.service.manager.exception.ManagerNotFoundException;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.task.ITaskManager;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.service.mapserver.MapServerAccess;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    protected String zkAddress;
    protected CuratorFramework zkClient;
    protected MongoDatabase mongoDatabase = null;
    protected MapServerAccess mapServerAccess;
    protected Logger logger = LoggerFactory.getLogger((String)"Client");
    public static String CMD_REQUEST = "/request";
    public static String CMD_RESPONSE = "/response";
    public static final String CMD_CREATE_TIME = "/time";
    public static final String ROOT = "/northpool_service_root";
    protected IDataSourcesManager dataSourcesManager;
    protected IDataServiceManager dataServiceManager;
    protected IVectorServiceManager vectorServiceManager;
    protected ITextureManager textureManager;
    protected IStyleManager styleManager;
    protected IFontManager fontManager;
    protected ITaskManager taskManager;
    protected ITileDataCellManager tileDataCellManager;
    private Integer httpMaxTotal = Runtime.getRuntime().availableProcessors();

    public Client(String zkAddress) {
        this.zkAddress = zkAddress;
        this.zkClient = this.initZkClient(zkAddress);
        this.logger.info("zk\u6b63\u5728\u8fde\u63a5");
        this.initManager();
    }

    public Client(String mongoUri, String zkAddress, String mapserverUrl) {
        this.mongoDatabase = this.initMongoClient(mongoUri);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{zkAddress})) {
            this.zkAddress = zkAddress;
            this.zkClient = this.initZkClient(zkAddress);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        this.initManager();
    }

    public void initManager() {
        try {
            ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
            this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
            this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
            this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
            this.textureManager = ManagerFactory.getManager(ITextureManager.class, this);
            this.styleManager = ManagerFactory.getManager(IStyleManager.class, this);
            this.fontManager = ManagerFactory.getManager(IFontManager.class, this);
            this.tileDataCellManager = ManagerFactory.getManager(ITileDataCellManager.class, this);
        }
        catch (ManagerDuplicateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ManagerNotFoundException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized CuratorFramework initZkClient(String zkAddress) {
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)zkAddress, (RetryPolicy)new RetryNTimes(10, 5000));
        client.start();
        return client;
    }

    public MongoDatabase initMongoClient(String uri) {
        MongoClient mongoClient;
        MongoClientURI mongoClientURI = new MongoClientURI(uri);
        try {
            mongoClient = MongoClients.create((String)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return mongoClient.getDatabase(mongoClientURI.getDatabase());
    }

    public CuratorFramework getZoo() {
        return this.zkClient;
    }

    public IVectorServiceManager getVectorServiceManager() {
        return this.vectorServiceManager;
    }

    public IDataSourcesManager getDataSourcesManager() {
        return this.dataSourcesManager;
    }

    public IDataServiceManager getDataServiceManager() {
        return this.dataServiceManager;
    }

    public ITextureManager getTextureManager() {
        return this.textureManager;
    }

    public IStyleManager getStyleManager() {
        return this.styleManager;
    }

    public IFontManager getFontManager() {
        return this.fontManager;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    public ITileDataCellManager getTileDataCellManager() {
        return this.tileDataCellManager;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public MongoDatabase initMongoClient() {
        return this.mongoDatabase;
    }

    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public MapServerAccess getMapServerAccess() {
        return new MapServerAccess(this.httpMaxTotal, 180000);
    }

    public void setMapServerAccess(MapServerAccess mapServerAccess) {
        this.mapServerAccess = mapServerAccess;
    }
}

