/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_source;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import org.bson.Document;

public class DataScourceShell
implements IDataSourceInService {
    protected IDataSource dataSource;
    protected String name;
    protected String id;
    public static final String SHELL_ID = "shellid";
    public static final String NAME = "name";
    public static final String ID = "id";
    private Client client;
    protected String mark;

    public String getMark() {
        return this.mark;
    }

    public DataScourceShell(Client client, String name, String id, IDataSource dataSource) {
        this.client = client;
        this.name = name;
        this.id = id;
        this.dataSource = dataSource;
        this.mark = dataSource.mark();
    }

    @Override
    public Constants.DATA_SOURCE_TYPE getDataSourceType() {
        return this.dataSource.getDataSourceType();
    }

    @Override
    public <ConnectionPool> ConnectionPool connection() throws Exception {
        return (ConnectionPool)this.dataSource.connection();
    }

    @Override
    public void resetConnection() {
        this.dataSource.resetConnection();
    }

    @Override
    public void destory() {
        this.dataSource.destory();
    }

    @Override
    public ITableOperator getTableBuilder(String tableName) throws Exception {
        return this.dataSource.getTableOperator(tableName);
    }

    public String toJson() {
        JSONObject object = (JSONObject)JSON.toJSON((Object)this.dataSource);
        object.put(SHELL_ID, (Object)this.id);
        object.put(NAME, (Object)this.name);
        object.put(ID, (Object)this.id);
        return object.toJSONString();
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String mark() {
        return this.dataSource.mark();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IDataSource getBean() {
        return this.dataSource;
    }

    @Override
    public void testConnection() throws Exception {
        this.dataSource.testConnection();
    }

    @Override
    public void refresh() {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.id);
        if (dataSourceInService == null) {
            return;
        }
        this.dataSource = dataSourceInService.getBean();
        this.mark = this.dataSource.mark();
    }

    @Override
    public Document toDocument() {
        return Document.parse((String)this.toJson());
    }

    public boolean equals(Object o) {
        IDataSourceInService dataSource = (IDataSourceInService)o;
        return this.dataSource.equals(dataSource.getBean());
    }

    @Override
    public String getVersion() {
        return this.dataSource.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.dataSource.setVersion(version);
    }
}

