/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_source;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.bean.JsonableBuilder;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.DataScourceShell;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;

public class DataSourceBuilder
implements JsonableBuilder<IDataSourceInService>,
DocumentableBuilder<IDataSourceInService> {
    private Client client;
    private static DataSourceBuilder _DATA_SOURCE_BUILDER = new DataSourceBuilder();
    public static final String DATA_SOURCE_TYPE_FILED = "dataSourceType";

    public static DataSourceBuilder getInstance() {
        return _DATA_SOURCE_BUILDER;
    }

    public DataSourceBuilder() {
    }

    public DataSourceBuilder(Client client) {
        this.client = client;
    }

    public IDataSourceInService fromJson(String json) throws Exception {
        JSONObject object = JSON.parseObject((String)json);
        String name = object.getString("name");
        String shellid = object.getString("shellid");
        IDataSource dataSource = IDataSource.fromJSON((String)json);
        if (dataSource.getId() == null) {
            return null;
        }
        return new DataScourceShell(this.client, name, shellid, dataSource);
    }

    @Override
    public IDataSourceInService fromDocument(Document str) throws Exception {
        str.remove((Object)"_id");
        return this.fromJson(str.toJson());
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

