/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.style;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBean;
import com.northpool.service.config.style.StyleShell;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import java.util.List;
import org.bson.Document;
import org.bson.types.Binary;

public class StyleBuilder
implements JsonableBuilder<IStyleService>,
DocumentableBuilder<IStyleService> {
    private static StyleBuilder _TEXTURE_BUILDER = new StyleBuilder();

    public static StyleBuilder getInstance() {
        return _TEXTURE_BUILDER;
    }

    public IStyleService fromJson(String json) throws Exception {
        StyleBean styleBean = (StyleBean)JSON.parseObject((String)json, StyleBean.class);
        return new StyleShell(styleBean);
    }

    @Override
    public IStyleService fromDocument(Document doc) {
        List textureLayer;
        List textureLabel;
        StyleBean style = new StyleBean();
        style.setOwnServer((String)doc.get((Object)"ownServer"));
        style.setName((String)doc.get((Object)"name"));
        style.setStyleJson((String)doc.get((Object)"styleJson"));
        style.setVersion((String)doc.get((Object)"version"));
        style.setUuid((String)doc.get((Object)"uuid"));
        List extFonts = (List)doc.get((Object)"extFonts");
        if (extFonts != null) {
            String[] extFontsArr = extFonts.toArray(new String[extFonts.size()]);
            style.setExtFonts(extFontsArr);
        }
        if ((textureLabel = (List)doc.get((Object)"textureLabel")) != null) {
            String[] textureLabelArr = textureLabel.toArray(new String[textureLabel.size()]);
            style.setTextureLabel(textureLabelArr);
        }
        if ((textureLayer = (List)doc.get((Object)"textureLayer")) != null) {
            String[] textureLayerArr = textureLayer.toArray(new String[textureLayer.size()]);
            style.setTextureLayer(textureLayerArr);
        }
        style.setStyleLabelJs(((Binary)doc.get((Object)"styleLabelJs")).getData());
        style.setStyleLayerJs(((Binary)doc.get((Object)"styleLayerJs")).getData());
        style.setStyleAvoidjs(((Binary)doc.get((Object)"styleAvoidjs")).getData());
        if (doc.get((Object)"queryLayer") != null) {
            style.setQueryLayer(((Binary)doc.get((Object)"queryLayer")).getData());
        }
        if (doc.get((Object)"queryLabel") != null) {
            style.setQueryLabel(((Binary)doc.get((Object)"queryLabel")).getData());
        }
        if (doc.get((Object)"mapboxStyle") != null) {
            style.setMapboxStyle(((Binary)doc.get((Object)"mapboxStyle")).getData());
        }
        if (doc.get((Object)"xmin") != null) {
            style.setXmin((Double)doc.get((Object)"xmin"));
            style.setYmin((Double)doc.get((Object)"ymin"));
            style.setXmax((Double)doc.get((Object)"xmax"));
            style.setYmax((Double)doc.get((Object)"ymax"));
        }
        return new StyleShell(style);
    }
}

