/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.resources.datatable.SpatialInfo;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.VectorServiceShell;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.exception.DataServiceNameDuplicateException;
import com.northpool.service.config.vector_service.exception.DataServiceNotFoundException;
import com.northpool.service.config.vector_service.exception.LayerCreateException;
import com.northpool.service.config.vector_service.exception.SpatialReferenceConflictException;
import com.northpool.service.config.vector_service.exception.VectorServiceNameInvalidException;
import com.northpool.service.config.vector_service.layer.Label;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.layer.LayerLevelBean;
import com.northpool.service.exception.LoadXmlException;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import com.northpool.service.xmlloader.vectorservice.VectorServiceLoader;
import com.northpool.spatial.Constants;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.QuadtreeGrid;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class VectorServiceBuilder
implements JsonableBuilder<IVectorService>,
DocumentableBuilder<IVectorService> {
    private Client client;

    public VectorServiceBuilder() {
    }

    public VectorServiceBuilder(Client client) {
        this.client = client;
    }

    public IVectorService fromJson(String str) throws Exception {
        VectorServiceBean vectorService = null;
        try {
            vectorService = (VectorServiceBean)JSON.parseObject((String)str, VectorServiceBean.class);
        }
        catch (Exception e) {
            throw new Exception(String.format("\u89e3\u6790JSON\u5931\u8d25:%s \u4e0d\u80fd\u7ffb\u8bd1\u6210vectorService", str));
        }
        if (vectorService.getId() == null) {
            return null;
        }
        VectorServiceShell vectorServiceShell = new VectorServiceShell(this.client, vectorService);
        return vectorServiceShell;
    }

    @Override
    public IVectorService fromDocument(Document str) throws Exception {
        str.remove((Object)"_id");
        return this.fromJson(str.toJson());
    }

    public IVectorService fromXmlInputStream(InputStream in) throws LoadXmlException {
        VectorServiceLoader xml = new VectorServiceLoader(this.client);
        VectorServiceBean service = xml.load(in);
        service.setVersion(new Date().getTime() + "");
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, service);
        return VectorServiceShell2;
    }

    public IVectorService fromDataService(String serverName, List<String> dataServiceIds) {
        return this.fromDataService(serverName, dataServiceIds, null, null);
    }

    public IVectorService fromDataService(String serverName, List<String> dataServiceIds, int[] origin, double[] resolutions) {
        if (dataServiceIds == null || dataServiceIds.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)serverName)) {
            throw new VectorServiceNameInvalidException(serverName);
        }
        VectorServiceBean vectorService = new VectorServiceBean();
        vectorService.setId(serverName);
        vectorService.setVersion(new Date().getTime() + "");
        List<IDataService> dataServices = dataServiceIds.stream().map(dataServiceId -> {
            IDataService dataService = (IDataService)this.client.getDataServiceManager().get((String)dataServiceId);
            if (dataService == null) {
                throw new DataServiceNotFoundException((String)dataServiceId);
            }
            return dataService;
        }).collect(Collectors.toList());
        HashSet<Integer> sridSet = new HashSet<Integer>();
        HashSet<String> namesSet = new HashSet<String>();
        HashMap<String, SpatialInfo> spatialInfoMap = new HashMap<String, SpatialInfo>();
        for (int i = 0; i < dataServices.size(); ++i) {
            IDataService dataService2 = (IDataService)dataServices.get(i);
            if (namesSet.contains(dataService2.getName())) {
                throw new DataServiceNameDuplicateException(dataService2.getName());
            }
            namesSet.add(dataService2.getName());
            SpatialInfo info = null;
            try {
                info = dataService2.getTable().spatialInfo();
            }
            catch (Exception e) {
                throw new LayerCreateException(e);
            }
            spatialInfoMap.put(dataService2.getName(), info);
            sridSet.add(info.getSrid());
        }
        if (sridSet.size() > 1 && sridSet.contains(3857)) {
            throw new SpatialReferenceConflictException(sridSet);
        }
        Constants.GRID_TYPE gridType = Constants.GRID_TYPE.tdt;
        if (origin != null && resolutions != null) {
            gridType = Constants.GRID_TYPE.esri;
        }
        Constants.GRID_UNIT gridBase = Constants.GRID_UNIT.degree;
        if (sridSet.contains(3857)) {
            gridBase = Constants.GRID_UNIT.meter;
        }
        String gridTreeName = gridType.name() + "_" + gridBase.name() + "_base512";
        vectorService.setGridTreeName(gridTreeName);
        vectorService.setResolutions(resolutions);
        vectorService.setOrigin(origin);
        QuadtreeGrid grid = GridManager.getQuadtreeGrid((String)gridTreeName);
        Integer startLevel = grid.getBeginLevel();
        Integer endLevel = LayerBean.MAX_LEVEL;
        Map<String, DataSetBean> dataSetMap = dataServices.stream().map(dataService -> {
            DataSetBean dataSet = new DataSetBean();
            dataSet.setId(dataService.getName());
            dataSet.setDataServiceId((String)dataService.getId());
            dataSet.setFilter(dataService.getBean().getFilter());
            return dataSet;
        }).collect(Collectors.toMap(dataSetBean -> dataSetBean.getId(), dataSetBean -> dataSetBean));
        vectorService.setDataSetMap(dataSetMap);
        Map<String, LayerBean> layerMap = this.getLayerMap(dataServices, dataSetMap, startLevel, endLevel);
        vectorService.setLayerMap(layerMap);
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, vectorService);
        return VectorServiceShell2;
    }

    private Map<String, LayerBean> getLayerMap(List<IDataService> dataServices, Map<String, DataSetBean> dataSetMap, Integer beginLevel, Integer endLevel) {
        Map<String, LayerBean> layerMap = dataServices.stream().map(dataService -> {
            try {
                return this.createLayer((IDataService)dataService, (DataSetBean)dataSetMap.get(dataService.getName()), beginLevel, endLevel);
            }
            catch (Exception e) {
                throw new LayerCreateException(dataService.getName());
            }
        }).collect(Collectors.toMap(layerBean -> layerBean.getId(), layerBean -> layerBean));
        return layerMap;
    }

    private LayerBean createLayer(IDataService dataService, DataSetBean dataSet, Integer beginLevel, Integer endLevel) {
        LayerBean layer = new LayerBean();
        layer.setBeginLevel(beginLevel);
        layer.setEndLevel(endLevel);
        layer.setId(dataService.getName());
        Constants.GEO_TYPE type = dataService.getGeoType();
        HashMap<Integer, LayerLevelBean> allLayerLevel = new HashMap<Integer, LayerLevelBean>();
        Integer i = layer.getBeginLevel();
        while (i <= layer.getEndLevel()) {
            LayerLevelBean layerLevel = new LayerLevelBean();
            layerLevel.setDataSetId(dataSet.getId());
            layerLevel.setLevel(i);
            allLayerLevel.put(i, layerLevel);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        layer.setLevelMap(allLayerLevel);
        if ((type == Constants.GEO_TYPE.LINESTRING || type == Constants.GEO_TYPE.MULTILINESTRING) && dataService.getBean().getAdvancedOptions().isHasLineLabel() || (type == Constants.GEO_TYPE.POLYGON || type == Constants.GEO_TYPE.MULTIPOLYGON) && dataService.getBean().getAdvancedOptions().isHasPolygonLabel().booleanValue() || type == Constants.GEO_TYPE.MULTIPOINT || type == Constants.GEO_TYPE.POINT) {
            layer.setHaveLabel(true);
            Label label = new Label();
            if (type == Constants.GEO_TYPE.LINESTRING || type == Constants.GEO_TYPE.MULTILINESTRING) {
                label.setType(Constants.LABEL_TYPE.line);
            } else if (type == Constants.GEO_TYPE.MULTIPOINT || type == Constants.GEO_TYPE.POINT) {
                label.setType(Constants.LABEL_TYPE.point);
            } else if (type == Constants.GEO_TYPE.POLYGON || type == Constants.GEO_TYPE.MULTIPOLYGON) {
                label.setType(Constants.LABEL_TYPE.area);
            }
            layer.setLabel(label);
        }
        return layer;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

