/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service.dataset;

import com.northpool.resources.datatable.IField;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.spatial.Constants;
import java.util.Map;

public class DataSetShell
implements IDataSet {
    protected DataSetBean dataSet;
    protected Client client;
    protected IDataService dataService;

    public DataSetShell(Client client, DataSetBean dataSet) {
        this.client = client;
        this.dataSet = dataSet;
        this.dataService = this.getDataService();
    }

    @Override
    public IDataService getDataService() {
        IDataService dataService = this.dataService;
        if (dataService == null && (dataService = (IDataService)this.client.getDataServiceManager().get(this.dataSet.getDataServiceId())) == null) {
            throw new RuntimeException(String.format("\u6570\u636e\u670d\u52a1%s\u4e0d\u5b58\u5728", this.dataSet.getDataServiceId()));
        }
        return dataService;
    }

    @Override
    public String getFilter() {
        return this.dataSet.getFilter();
    }

    @Override
    public String getSortFiled() {
        return this.dataSet.getSortFiled();
    }

    @Override
    public String getSort() {
        return this.dataSet.getSort();
    }

    @Override
    public String getSpatialFilter() {
        return this.dataSet.getSpatialFilter();
    }

    @Override
    public Map<String, IField> getFieldsMap() {
        return this.dataService.getFieldMap();
    }

    @Override
    public String getIdField() {
        return this.dataService.getIdFieldName();
    }

    @Override
    public String getSpatialField() {
        return this.dataService.getSpatialFieldName();
    }

    @Override
    public Constants.GEO_TYPE getGeometryType() {
        return this.dataService.getGeoType();
    }

    @Override
    public IDataSourceInService getDataSource() {
        return this.dataService.getDataSource();
    }

    @Override
    public String[] getFieldsArr() {
        return this.dataService.getAliasFiledArr();
    }
}

