/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service.storage;

import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;

public class StorageInfoShell
implements IStorageInfo {
    protected StorageInfoBean bean;
    protected Client client;

    public StorageInfoShell(Client client, StorageInfoBean storageBean) {
        this.client = client;
        this.bean = storageBean;
    }

    @Override
    public IDataSourceInService getDataSource() {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService == null) {
            throw new RuntimeException(String.format("\u6570\u636e\u6e90%s\u4e0d\u5b58\u5728", this.bean.getDataSourceId()));
        }
        return dataSourceInService;
    }

    @Override
    public StorageInfoBean getBean() {
        return this.bean;
    }

    @Override
    public Integer getStartLevel() {
        return this.bean.getStartLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.bean.getEndLevel();
    }

    @Override
    public String getStorageName() {
        return this.bean.getStorageName();
    }

    @Override
    public String getLabelStorageName() {
        return this.bean.getLabelStorageName();
    }

    @Override
    public Boolean isCompleted() {
        return this.bean.isCompleted();
    }

    @Override
    public void setCompleted(boolean completed) {
        this.bean.setCompleted(completed);
    }

    @Override
    public void drop() {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService != null) {
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            factory.dropCollection(this.getStorageName());
            if (this.getLabelStorageName() != null) {
                factory.dropCollection(this.getLabelStorageName());
            }
        }
    }

    @Override
    public void rename(String newName) {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService != null) {
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            factory.renameCollection(this.getStorageName(), newName);
            this.bean.setStorageName(newName);
        }
    }

    @Override
    public void renameLabel(String newName) {
        IDataSourceInService dataSourceInService = (IDataSourceInService)this.client.getDataSourcesManager().get(this.bean.getDataSourceId());
        if (dataSourceInService != null) {
            MongodbFactory factory = ((MongodbDataSource)dataSourceInService.getBean()).factory();
            factory.renameCollection(this.getLabelStorageName(), newName);
            this.bean.setLabelStorageName(newName);
        }
    }
}

