/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.dao;

import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import com.northpool.bean.Idable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.dao.IMongoDao;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMongoDao<T extends Idable<String> & IDocumentAble, Builder extends JsonableBuilder<T> & DocumentableBuilder<T>>
implements IMongoDao<T> {
    Logger logger = LoggerFactory.getLogger(AbstractMongoDao.class);
    protected MongoCollection<Document> collection;
    protected MongoDatabase database;
    protected String idFieldName = "id";
    protected Builder beanBuilder;

    public AbstractMongoDao(MongoDatabase mongoDatabase, String collectionName, Builder builder) {
        this.database = mongoDatabase;
        if (StringUtils.isNotEmpty((CharSequence)collectionName)) {
            this.collection = mongoDatabase.getCollection(collectionName);
        }
        this.beanBuilder = builder;
    }

    public AbstractMongoDao(MongoDatabase mongoDatabase, String collectionName, String idFieldName, Builder builder) {
        this.database = mongoDatabase;
        if (StringUtils.isNotEmpty((CharSequence)collectionName)) {
            this.collection = mongoDatabase.getCollection(collectionName);
        }
        this.idFieldName = idFieldName;
        this.beanBuilder = builder;
    }

    @Override
    public void updateOne(String id, T bean) {
        Document doc = ((IDocumentAble)bean).toDocument();
        this.updateOne(id, doc);
    }

    @Override
    public void insertOne(T bean) {
        Document doc = ((IDocumentAble)bean).toDocument();
        this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)doc);
    }

    @Override
    public void deleteone(String id) {
        this.collection.deleteOne((Bson)new Document(this.idFieldName, (Object)id));
    }

    @Override
    public T findone(String id) {
        FindIterable<Document> it = this.findCollection((Bson)new Document(this.idFieldName, (Object)id));
        Document doc = (Document)it.first();
        if (doc == null) {
            return null;
        }
        Idable bean = null;
        try {
            bean = (Idable)((DocumentableBuilder)this.beanBuilder).fromDocument(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)bean;
    }

    @Override
    public T findone(Bson filter) {
        FindIterable<Document> it = this.findCollection(filter);
        Document doc = (Document)it.first();
        Idable bean = null;
        if (doc == null) {
            return null;
        }
        try {
            bean = (Idable)((DocumentableBuilder)this.beanBuilder).fromDocument(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)bean;
    }

    @Override
    public List<T> find(Bson filter) {
        FindIterable<Document> it = this.findCollection(filter);
        MongoCursor cursor = it.iterator();
        ArrayList<Idable> list = new ArrayList<Idable>();
        while (cursor.hasNext()) {
            Document doc = (Document)cursor.next();
            Idable bean = null;
            try {
                bean = (Idable)((DocumentableBuilder)this.beanBuilder).fromDocument(doc);
            }
            catch (Exception e) {
                String id = doc.getString((Object)this.idFieldName);
                if (id.startsWith("temp_")) {
                    this.deleteone(id);
                }
                this.logger.info(this.getClass().getName() + " : " + id + " \u53cd\u5e8f\u5217\u5316\u5931\u8d25");
                continue;
            }
            if (bean == null) continue;
            list.add(bean);
        }
        return list;
    }

    @Override
    public Long count(Bson filter) {
        return this.collection.countDocuments(filter);
    }

    @Override
    public Boolean exists(String id) {
        return this.findone((Bson)new Document(this.idFieldName, (Object)id)) != null;
    }

    public void createIndex(String[] indexArray) {
        this.collection.createIndex(Indexes.ascending((String[])indexArray));
    }

    public MongoCursor<Document> find(Bson filter, Bson projection) {
        FindIterable it = this.findCollection(filter).projection(projection);
        MongoCursor cursor = it.iterator();
        return cursor;
    }

    public Document findone(Bson filter, Bson projection) {
        FindIterable it = this.findCollection(filter).projection(projection);
        return (Document)it.first();
    }

    public void insert(Document doc) {
        this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertOne((Object)doc);
    }

    public void insert(List<Document> list) {
        this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).insertMany(list);
    }

    public void update(Bson filter, Document doc) {
        this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne(filter, (Bson)doc);
    }

    public void updateOne(Bson filter, Document doc) {
        this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne(filter, (Object)doc);
    }

    @Override
    public void updateOne(String id, Document doc) {
        this.collection.withWriteConcern(WriteConcern.ACKNOWLEDGED).replaceOne((Bson)new Document(this.idFieldName, (Object)id), (Object)doc);
    }

    public void insertSaft(Document doc) {
        this.collection.withWriteConcern(WriteConcern.JOURNALED).insertOne((Object)doc);
    }

    public FindIterable<Document> findCollection(Bson filter) {
        FindIterable it = this.collection.find(filter);
        return it;
    }

    public FindIterable<Document> findCollection(Bson filter, Bson projection) {
        return this.findCollection(filter).projection(projection);
    }

    public void deleteone(Bson filter) {
        this.collection.deleteOne(filter);
    }
}

