/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.dao;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdExistsException;
import com.northpool.service.client.Client;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.dao.EventMessage;
import com.northpool.service.dao.IMongoDao;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.Json2BeanFailedException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkDao<T extends Jsonable & Idable<String>, Builder extends JsonableBuilder<T>> {
    Logger logger = LoggerFactory.getLogger(AbstractZkDao.class);
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName;
    protected Client client;
    protected final Boolean readOnly;
    protected String managerRoot;
    protected PathChildrenCache HolderCache;
    protected static final String INFO_FIELD = "version";
    protected Builder beanBuilder;
    protected Boolean isReady = false;
    protected EventContainer<Listener> eventContainer = new EventContainer();
    protected IClientManager manager;
    protected IMongoDao<T> mongoDao;
    protected static boolean hasListener = false;
    protected static CompletableFuture<String> listener;
    protected static CompletableFuture<CompletableFuture> listenerIsSet;
    protected static ThreadPoolExecutor pool;

    public AbstractZkDao(String idFieldName, Builder beanBuilder, QueryHashTableHeap<String, T> table, Client client, String managerRoot, Boolean readOnly, IMongoDao<T> mongoDao) {
        this.idFieldName = idFieldName;
        this.table = table;
        this.readOnly = readOnly;
        this.managerRoot = "/northpool_service_root" + "/" + managerRoot;
        this.client = client;
        this.beanBuilder = beanBuilder;
        this.mongoDao = mongoDao;
    }

    public void init() {
        try {
            this.createRoot();
            this.addZKListener();
            this.syncToZK();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isReady = true;
    }

    protected void createRoot() throws Exception {
        if (this.client.getZoo().checkExists().forPath(this.managerRoot) == null) {
            ((ACLBackgroundPathAndBytesable)this.client.getZoo().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.managerRoot);
        }
    }

    public synchronized void syncToZK() throws Exception {
        this.isReady = false;
        this.createRoot();
        List nodes = (List)this.client.getZoo().getChildren().forPath(this.managerRoot);
        nodes = nodes.stream().map(path -> {
            int index = path.lastIndexOf("/");
            if (index != -1) {
                return path.substring(index);
            }
            return path;
        }).collect(Collectors.toList());
        IScroll scroll = this.table.scroll(new QueryFilter());
        while (scroll.hasNext()) {
            Jsonable t = (Jsonable)scroll.next();
            if (nodes.contains(((Idable)t).getId())) continue;
            this.saveBeanTozk(t);
        }
        this.isReady = true;
    }

    public void saveBeanTozk(T t) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        List<CuratorOp> iList = this.createBeanNode(transaction, t);
        this.client.getZoo().transaction().forOperations(iList);
    }

    public String getVersionFromZK(String id) throws Exception {
        byte[] info_byte;
        String path = this.path(id);
        String data_path = path + "/" + INFO_FIELD;
        try {
            info_byte = (byte[])this.client.getZoo().getData().forPath(data_path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\u8282\u70b9" + data_path + " \u6ca1\u6709\u4fe1\u606f");
        }
        return new String(info_byte, "utf-8");
    }

    public T getFromMongo(String id) throws Exception {
        if (!this.exists(id).booleanValue()) {
            return null;
        }
        try {
            T bean = this.mongoDao.findone(id);
            return bean;
        }
        catch (Exception e) {
            this.logger.info(this.managerRoot + "/" + id + "\u53cd\u5e8f\u5217\u5316\u5931\u8d25");
            if (id.startsWith("temp_")) {
                this.zkRemoveBean(id);
            }
            throw new Json2BeanFailedException(e);
        }
    }

    protected void saveBeanToHashTable(T bean) {
        this.table.insert(bean);
    }

    protected void removeBeanToHashTable(String pk) {
        this.table.remove((Serializable)((Object)pk));
    }

    protected void updateBeanToHashTable(T bean) {
        this.table.update(bean);
    }

    protected void addZKListener() throws Exception {
        String listenterPath = this.managerRoot;
        this.HolderCache = new PathChildrenCache(this.client.getZoo(), listenterPath, true);
        this.HolderCache.getListenable().addListener((client, event) -> {
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED) return;
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_RECONNECTED) return;
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_LOST) {
                return;
            }
            ChildData data = event.getData();
            String path = new String(data.getData(), "utf-8");
            int index = path.lastIndexOf("/");
            String id = path;
            if (index != -1) {
                id = path.substring(index);
            }
            Object future = null;
            switch (event.getType()) {
                case CHILD_ADDED: {
                    T bean = this.getFromMongo(id);
                    while (bean == null) {
                        this.logger.warn(this.getClass().getName() + ":\u4ecemongo\u518d\u6b21\u83b7\u53d6id\u4e3a" + id + "\u7684\u6570\u636e");
                        bean = this.getFromMongo(id);
                        Thread.sleep(100L);
                    }
                    try {
                        if (this.table.get((Serializable)((Object)id)) == null) {
                            if (bean instanceof IDataService) {
                                IDataService dataService = (IDataService)bean;
                                dataService.getDataSource().getBean().getTable(dataService.getTableName()).reload();
                            }
                            this.saveBeanToHashTable(bean);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (e.getCause() == null) throw e;
                        if (!(e.getCause() instanceof IdExistsException)) throw e;
                    }
                    this.triggerEvent(id, event.getType());
                    return;
                }
                case CHILD_REMOVED: {
                    boolean isExists = this.exists(id);
                    if (!isExists) {
                        this.removeBeanToHashTable(id);
                    } else {
                        IVersionAble service;
                        String version = this.getVersionFromZK(id);
                        Jsonable cacheBean = (Jsonable)this.table.get((Serializable)((Object)id));
                        if (cacheBean instanceof IVersionAble && ObjectUtils.notEqual((Object)(service = (IVersionAble)cacheBean).getVersion(), (Object)version)) {
                            this.removeBeanToHashTable(id);
                        }
                    }
                    this.triggerEvent(path, event.getType());
                    return;
                }
                case CHILD_UPDATED: {
                    T bean = this.getFromMongo(id);
                    this.updateBeanToHashTable(bean);
                    this.triggerEvent(path, event.getType());
                    return;
                }
            }
        }, (Executor)pool);
        this.HolderCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
    }

    private void triggerEvent(String id, PathChildrenCacheEvent.Type eventType) throws ExecutionException, InterruptedException {
        if (hasListener && this.manager != null) {
            CompletableFuture<String> future = null;
            EventMessage message = new EventMessage();
            try {
                future = AbstractZkDao.getListener();
                listener = null;
                listenerIsSet = null;
                message.setBeanType(this.managerRoot);
                message.setEventType(eventType.name());
                message.setId(id);
                if (eventType != PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                    message.setBean(this.manager.getJSON(id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                future.completeExceptionally(e);
            }
            future.complete(message.toString());
        }
    }

    public Boolean exists(String id) throws ZKException {
        boolean isExists = false;
        try {
            isExists = this.client.getZoo().checkExists().forPath(this.path(id)) != null;
        }
        catch (Exception e) {
            throw new ZKException(e);
        }
        return isExists;
    }

    public String path(String id) {
        String path = this.managerRoot + "/" + id;
        return path;
    }

    protected void isReady() throws ZKException {
        if (!this.isReady.booleanValue()) {
            throw new ZKException("ZK\u5ba2\u6237\u7aef\u6ca1\u6709\u51c6\u5907\u597d");
        }
    }

    protected List<CuratorOp> createBeanNode(TransactionOp transaction, T t) throws Exception {
        String version;
        String id = (String)((Idable)t).getId();
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        CuratorOp createOp1 = (CuratorOp)((ACLPathAndBytesable)transaction.create().withMode(CreateMode.PERSISTENT)).forPath(path, id.getBytes("utf-8"));
        iList.add(createOp1);
        CuratorOp createOp2 = (CuratorOp)transaction.create().forPath(path + "/id", ((String)((Idable)t).getId()).getBytes("utf-8"));
        iList.add(createOp2);
        if (t instanceof IVersionAble && (version = ((IVersionAble)t).getVersion()) != null) {
            CuratorOp createOp3 = (CuratorOp)transaction.create().forPath(path + "/" + INFO_FIELD, version.getBytes("utf-8"));
            iList.add(createOp3);
        }
        this.AddExtendsInfo2BeanNode(path, iList, transaction, t);
        return iList;
    }

    public List<CuratorOp> deleteBeanNode(TransactionOp transaction, String id) throws Exception {
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        List nodes = (List)this.client.getZoo().getChildren().forPath(path);
        for (String node : nodes) {
            String sub_path = path + "/" + node;
            CuratorOp delete_sub_node = (CuratorOp)transaction.delete().forPath(sub_path);
            iList.add(delete_sub_node);
        }
        CuratorOp delete = (CuratorOp)transaction.delete().forPath(path);
        iList.add(delete);
        return iList;
    }

    protected abstract void AddExtendsInfo2BeanNode(String var1, List<CuratorOp> var2, TransactionOp var3, T var4) throws Exception;

    public void zkRemoveBean(String id) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        List<CuratorOp> iList = this.deleteBeanNode(transaction, id);
        this.client.getZoo().transaction().forOperations(iList);
    }

    public void updateBeanTozk(T t) throws ZKException {
        String id = (String)((Idable)t).getId();
        String path = this.path(id);
        try {
            if (this.client.getZoo().checkExists().forPath(path) == null) {
                this.saveBeanTozk(t);
            } else {
                TransactionOp transaction = this.client.getZoo().transactionOp();
                ArrayList<CuratorOp> iListUpdate = new ArrayList<CuratorOp>();
                List<CuratorOp> iListDelete = this.deleteBeanNode(transaction, id);
                iListUpdate.addAll(iListDelete);
                List<CuratorOp> iListAdd = this.createBeanNode(transaction, t);
                iListUpdate.addAll(iListAdd);
                this.client.getZoo().transaction().forOperations(iListUpdate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZKException(e);
        }
    }

    public static CompletableFuture<String> getListener() throws ExecutionException, InterruptedException {
        if (listener != null) {
            return listener;
        }
        listenerIsSet = new CompletableFuture();
        return listenerIsSet.get();
    }

    public static void setListener(Consumer callback, Function exception) {
        hasListener = true;
        listener = new CompletableFuture();
        if (callback != null) {
            listener.thenAcceptAsync(callback);
        }
        if (exception != null) {
            listener.exceptionally(exception);
        }
        if (listenerIsSet != null) {
            listenerIsSet.complete(listener);
        }
    }

    static {
        pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                throw new RuntimeException("\u961f\u5217\u5df2\u6ee1");
            }
        });
    }
}

