/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager;

import com.northpool.service.client.Client;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.exception.ManagerDuplicateException;
import com.northpool.service.manager.exception.ManagerNotFoundException;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ManagerFactory {
    static ClassLoader loader;

    public static <T extends IClientManager> T getManager(Class<T> type, Client client) throws ManagerDuplicateException, ManagerNotFoundException {
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
        }
        ServiceLoader<T> loader = ServiceLoader.load(type);
        Iterator<T> iterator = loader.iterator();
        IClientManager manager = null;
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            manager = (IClientManager)iterator.next();
        }
        if (count > 1) {
            throw new ManagerDuplicateException(type.getName() + "\u6709\u591a\u4e2a\u5b9e\u73b0\u7c7b");
        }
        if (manager != null) {
            manager.setClient(client);
            manager.init();
        }
        return (T)manager;
    }

    public static void setLoader(ClassLoader loader) {
        ManagerFactory.loader = loader;
    }
}

