/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.abstractclass;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.exception.UException;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.client.Client;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.dao.AbstractZkDao;
import com.northpool.service.dao.IMongoDao;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import com.northpool.service.manager.abstractclass.EventMessage;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public abstract class AbstractManager<T extends Jsonable & Idable<String>, Builder extends JsonableBuilder<T> & DocumentableBuilder<T>> {
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName = "id";
    protected Client client;
    protected Boolean readOnly = false;
    protected String managerRoot;
    protected PathChildrenCache HolderCache;
    protected static final String INFO_FIELD = "data";
    protected Builder beanBuilder;
    protected Boolean isReady = false;
    protected EventContainer<Listener> eventContainer = new EventContainer();
    protected AbstractZkDao<T, Builder> zkDao;
    protected IMongoDao<T> mongoDao;

    public AbstractManager(Builder beanBuilder, String managerRoot) {
        this.managerRoot = managerRoot;
        this.beanBuilder = beanBuilder;
    }

    public void init() {
        this.table = new QueryHashTableHeap(this.idFieldName);
        List<T> list = this.mongoDao.find((Bson)new BsonDocument());
        this.table.insertMany(list);
        if (this.client.getZoo() == null) {
            throw new RuntimeException("zk\u6ca1\u6709\u51c6\u5907\u597d");
        }
        this.isReady = true;
    }

    protected void saveBeanToHashTable(T bean) {
        if (this.table == null) {
            return;
        }
        this.table.insert(bean);
    }

    protected void removeBeanToHashTable(String pk) {
        if (this.table == null) {
            return;
        }
        this.table.remove((Serializable)((Object)pk));
    }

    protected void updateBeanToHashTable(T bean) {
        if (this.table == null) {
            return;
        }
        this.table.update(bean);
    }

    public Boolean exists(String id) throws ZKException {
        if (this.table.get((Serializable)((Object)id)) != null) {
            return true;
        }
        if (this.zkDao != null) {
            boolean isExists = this.zkDao.exists(id);
            return isExists;
        }
        if (this.mongoDao != null) {
            return this.mongoDao.exists(id);
        }
        return false;
    }

    protected void isReady() throws ZKException {
    }

    protected void doAdd(T t) throws ZKException {
        String version;
        this.isReady();
        String id = (String)((Idable)t).getId();
        if (id == null) {
            throw new IdFieldValueEmptyException(this.idFieldName, t);
        }
        if (this.exists(id).booleanValue()) {
            throw new ExistsIdException(id);
        }
        if (t instanceof IVersionAble && (version = ((IVersionAble)t).getVersion()) == null) {
            ((IVersionAble)t).setVersion(new Date().getTime() + "");
        }
        this.saveBeanToHashTable(t);
        if (this.mongoDao != null) {
            this.mongoDao.insertOne(t);
        }
        if (this.zkDao != null) {
            try {
                this.zkDao.saveBeanTozk(t);
            }
            catch (Exception e) {
                UException.printStackTrace((Throwable)e);
                this.removeBeanToHashTable(id);
                this.mongoDao.deleteone(id);
                throw new ZKException(e);
            }
        }
        this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.register.name(), new Object[]{id, t});
    }

    protected void doUpdate(T t) throws ZKException {
        this.isReady();
        String id = (String)((Idable)t).getId();
        if (id == null) {
            throw new IdFieldValueEmptyException(this.idFieldName, t);
        }
        if (!this.exists(id).booleanValue()) {
            throw new NotFoundException(id);
        }
        if (t instanceof IVersionAble) {
            IVersionAble versionAble = (IVersionAble)t;
            versionAble.setVersion(new Date().getTime() + "");
        }
        this.table.update(t);
        if (this.mongoDao != null) {
            this.mongoDao.updateOne(id, t);
        }
        if (this.zkDao != null) {
            this.zkDao.updateBeanTozk(t);
        }
        this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.update.name(), new Object[]{id, t});
    }

    protected void doRemove(String id) throws ZKException, NotFoundException {
        this.isReady();
        if (!this.exists(id).booleanValue()) {
            throw new NotFoundException(id);
        }
        this.removeBeanToHashTable(id);
        if (this.mongoDao != null) {
            this.mongoDao.deleteone(id);
        }
        if (this.zkDao != null) {
            try {
                this.zkDao.zkRemoveBean(id);
            }
            catch (Exception e) {
                UException.printStackTrace((Throwable)e);
                throw new ZKException(e);
            }
        }
        this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.unRegister.name(), new Object[]{id, this.get(id)});
    }

    public void on(EventMessage.EVENT_TYPE type, EventMessage<T> e) {
        this.eventContainer.on(type.name(), parameter -> {
            Jsonable t = parameter[1] == null ? null : (Jsonable)parameter[1];
            e.fire((String)parameter[0], t);
        });
    }

    public List<T> list(QueryFilter queryFilter) {
        if (this.table != null) {
            return this.table.query(queryFilter);
        }
        return null;
    }

    public T findOne(QueryFilter queryFilter) {
        IScroll scroll = this.table.scroll(queryFilter);
        if (scroll.hasNext()) {
            return (T)((Jsonable)scroll.next());
        }
        return null;
    }

    public IScroll<T> scroll(QueryFilter queryFilter) {
        if (this.table != null) {
            return this.table.scroll(queryFilter);
        }
        return null;
    }

    public T get(String id) {
        return (T)((Jsonable)this.table.get((Serializable)((Object)id)));
    }

    public String getJSON(String id) {
        T bean = this.get(id);
        if (bean != null) {
            return bean.toJson();
        }
        return null;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

