/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.data_service;

import com.northpool.exception.UException;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.service.config.data_service.DataServiceBuilder;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleJson;
import com.northpool.service.config.style.layer.AbstractLayer;
import com.northpool.service.config.style.layer.Layer;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBuilder;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.dao.data_service.DataServiceMongoDao;
import com.northpool.service.dao.data_service.DataServiceZkDao;
import com.northpool.service.manager.abstractclass.InvalidException;
import com.northpool.service.manager.abstractclass.RollbackException;
import com.northpool.service.manager.abstractclass.ServiceManager;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DataServiceManager
extends ServiceManager<IDataService, DataServiceBuilder>
implements IDataServiceManager {
    protected static final String MANAGER_ROOT = "data_service";

    public DataServiceManager() {
        super(new DataServiceBuilder(), MANAGER_ROOT);
    }

    @Override
    public void init() {
        ((DataServiceBuilder)this.beanBuilder).setClient(this.client);
        this.mongoDao = new DataServiceMongoDao(this.client.initMongoClient(), (DataServiceBuilder)this.beanBuilder);
        super.init();
        if (this.client.getZoo() != null) {
            this.zkDao = new DataServiceZkDao(this.idFieldName, (DataServiceBuilder)this.beanBuilder, (QueryHashTableHeap<String, IDataService>)this.table, this.client, this.managerRoot, this.readOnly, this.mongoDao);
            this.zkDao.init();
        }
    }

    @Override
    public void register(IDataService dataService) throws ZKException {
        this.checkInvalid(dataService);
        super.doAdd(dataService);
    }

    protected void checkInvalid(IDataService dataService) throws InvalidException {
        ITable table = null;
        try {
            table = dataService.getTable();
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw new InvalidException("dataService", dataService.mark() + "\u83b7\u5f97\u8fde\u63a5\u5931\u8d25 ,\u9519\u8bef\u539f\u56e0:" + e.getMessage());
        }
        String[] aliasFields = dataService.getAliasFiledArr();
        HashSet<String> fieldsSet = new HashSet<String>();
        HashSet<String> duplicateSet = new HashSet<String>();
        int len = aliasFields.length;
        for (int i = 0; i < len; ++i) {
            if (fieldsSet.contains(aliasFields[i])) {
                duplicateSet.add(aliasFields[i]);
                continue;
            }
            fieldsSet.add(aliasFields[i]);
        }
        if (!duplicateSet.isEmpty()) {
            String duplicateStr = StringUtils.join(duplicateSet, (String)",");
            throw new InvalidException("dataService", "\u5b57\u6bb5: " + duplicateStr + " \u5b58\u5728\u522b\u540d\u51b2\u7a81\uff0c\u8bf7\u52ff\u9009\u62e9\u5b58\u5728\u522b\u540d\u51b2\u7a81\u7684\u5b57\u6bb5");
        }
    }

    @Override
    public void unRegister(String id) throws ZKException {
        super.doRemove(id);
    }

    @Override
    public void update(IDataService dataService) throws ZKException {
        this.checkInvalid(dataService);
        dataService.getBean().setFields(null);
        dataService.getFields();
        super.doUpdate(dataService);
        List<IVectorService> relatedServices = this.findRelatedVectorService(dataService);
        this.updateRelatedVectorService(relatedServices);
    }

    private List<IVectorService> findRelatedVectorService(IDataService dataService) {
        IVectorServiceManager vectorServiceManager = this.client.getVectorServiceManager();
        List services = vectorServiceManager.list(new QueryFilter());
        List<IVectorService> relatedServices = services.stream().filter(service -> {
            for (ILayer layer : service.getLayerMap().values()) {
                for (ILayerLevel level : layer.getLevelMap().values()) {
                    if (!((String)dataService.getId()).equals(level.getDataSet().getDataService().getId())) continue;
                    return true;
                }
            }
            return false;
        }).collect(Collectors.toList());
        return relatedServices;
    }

    private List<IStyleService> findRelatedStyle(List<IVectorService> services) {
        ArrayList<IStyleService> styles = new ArrayList<IStyleService>();
        IStyleManager styleManager = this.client.getStyleManager();
        for (int i = 0; i < services.size(); ++i) {
            IVectorService service = services.get(i);
            QueryFilter filter = new QueryFilter();
            filter.addFilter("ownServer", Constants.OPERATION.EQ, new Object[]{service.getId()});
            List<IStyleService> stylesList = styleManager.list(filter);
            styles.addAll(stylesList);
        }
        return styles;
    }

    private void updateRelatedVectorService(List<IVectorService> relatedServices) throws ZKException {
        IVectorServiceManager vectorServiceManager = this.client.getVectorServiceManager();
        for (IVectorService service : relatedServices) {
            IVectorService newService = new VectorServiceBuilder(service.getClient()).fromDataService(service.getId(), service.getDataServiceIds(), service.getOrigin(), service.getResolutions());
            if (service.getStorageInfo() != null) {
                newService.addStorageInfo(service.getStorageInfo());
            }
            if (service.getUtfgridInfo() != null) {
                newService.addUtfgridInfo(service.getUtfgridInfo());
            }
            if (service.getCacheInfo() != null) {
                newService.addCacheInfo(service.getCacheInfo());
            }
            vectorServiceManager.update(newService);
        }
    }

    private void updateRelatedStyle(List<IStyleService> relatedStyles, String oldName, String newName) throws RollbackException, ZKException {
        StyleJson styleJson;
        IStyleManager styleManager = this.client.getStyleManager();
        boolean allPass = true;
        Throwable zkException = null;
        for (IStyleService style : relatedStyles) {
            styleJson = style.getStyleJsonBean();
            this.updateLayers(styleJson.getLayers(), oldName, newName);
            style.setStyleJson(styleJson.toJson());
            try {
                styleManager.save(style);
            }
            catch (ZKException e) {
                UException.printStackTrace((Throwable)e);
                allPass = false;
                zkException = e;
                break;
            }
        }
        if (!allPass) {
            for (IStyleService style : relatedStyles) {
                styleJson = style.getStyleJsonBean();
                this.updateLayers(styleJson.getLayers(), newName, oldName);
                style.setStyleJson(styleJson.toJson());
                try {
                    styleManager.save(style);
                }
                catch (ZKException e) {
                    UException.printStackTrace((Throwable)e);
                    allPass = false;
                    throw new RollbackException(e);
                }
            }
            throw new ZKException(zkException.getMessage());
        }
    }

    private void updateLayers(List<AbstractLayer> layers, String oldName, String newName) {
        int size = layers.size();
        for (int i = 0; i < size; ++i) {
            AbstractLayer layer = layers.get(i);
            if (layer instanceof Layer) {
                if (((Layer)layer).getData().equals(oldName)) {
                    ((Layer)layer).setData(newName);
                    continue;
                }
                if (!((Layer)layer).getData().equals(oldName + LayerBean.LABEL_SUFFIX)) continue;
                ((Layer)layer).setData(newName + LayerBean.LABEL_SUFFIX);
                continue;
            }
            this.updateLayers(layer.getChildren(), oldName, newName);
        }
    }

    @Override
    public IScroll<IDataService> scroll(QueryFilter queryFilter) {
        return super.scroll(queryFilter);
    }

    @Override
    public void start(String id) throws ZKException {
        super.start(id);
    }

    @Override
    public void stop(String id) throws ZKException {
        super.stop(id);
    }

    @Override
    public IDataService get(String id) {
        return (IDataService)super.get(id);
    }

    @Override
    public IDataService findOne(QueryFilter queryFilter) {
        queryFilter.setStart(Integer.valueOf(0));
        queryFilter.setLimit(Integer.valueOf(1));
        List iList = super.list(queryFilter);
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return (IDataService)iList.get(0);
    }

    @Override
    public void rename(String id, String newName) throws ZKException {
        IDataService dataService = this.get(id);
        this.rename(dataService, newName);
    }

    @Override
    public void rename(IDataService dataService, String newName) throws ZKException {
        if (dataService == null) {
            throw new RuntimeException("\u6570\u636e\u670d\u52a1 " + (String)dataService.getId() + " \u4e0d\u5b58\u5728");
        }
        String oldName = dataService.getName();
        dataService.getBean().setName(newName);
        IStorageInfo storageInfo = dataService.getStorageInfo();
        if (storageInfo != null) {
            storageInfo.rename(dataService.getStorageName());
            if (storageInfo.getLabelStorageName() != null) {
                storageInfo.renameLabel(dataService.getLabelStorageName());
            }
        }
        List<IVectorService> relatedServices = this.findRelatedVectorService(dataService);
        List<IStyleService> relatedStyles = this.findRelatedStyle(relatedServices);
        dataService.getBean().setFields(null);
        dataService.getFields();
        this.doUpdate(dataService);
        this.updateRelatedVectorService(relatedServices);
        try {
            this.updateRelatedStyle(relatedStyles, oldName, newName);
        }
        catch (RollbackException e) {
            e.printStackTrace();
            String msg = "\u4e25\u91cd\u9519\u8bef dataService id : " + (String)dataService.getId() + " \u66f4\u6539\u540d\u79f0\u56de\u6eda\u5931\u8d25 \u9519\u8bef : " + e.getMessage();
            throw new ZKException(msg);
        }
    }
}

