/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.data_sources;

import com.northpool.exception.NotSupport;
import com.northpool.resources.Constants;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.service.config.data_source.DataSourceBuilder;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.dao.data_sources.DataSourceMongoDao;
import com.northpool.service.dao.data_sources.DataSourcesZkDao;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.EventMessage;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcesManager
extends AbstractManager<IDataSourceInService, DataSourceBuilder>
implements IDataSourcesManager {
    protected static final String MANAGER_ROOT = "data_sources";
    protected Logger logger = LoggerFactory.getLogger(DataSourcesManager.class);

    public DataSourcesManager() {
        super(DataSourceBuilder.getInstance(), MANAGER_ROOT);
    }

    @Override
    public void init() {
        ((DataSourceBuilder)this.beanBuilder).setClient(this.client);
        this.mongoDao = new DataSourceMongoDao(this.client.initMongoClient(), (DataSourceBuilder)this.beanBuilder);
        super.init();
        if (this.client.getZoo() != null) {
            this.zkDao = new DataSourcesZkDao(this.idFieldName, (DataSourceBuilder)this.beanBuilder, (QueryHashTableHeap<String, IDataSourceInService>)this.table, this.client, this.managerRoot, this.readOnly, this.mongoDao);
            this.zkDao.init();
        }
    }

    protected void addListener() {
        this.on(EventMessage.EVENT_TYPE.unRegister, (id, t) -> {
            this.logger.info("\u6570\u636e\u6e90" + id + "\u5df2\u88ab\u5220\u9664");
            t.destory();
        });
        this.on(EventMessage.EVENT_TYPE.update, (id, t) -> {
            this.logger.info("\u6570\u636e\u6e90" + id + "\u5df2\u66f4\u65b0");
            t.resetConnection();
        });
    }

    @Override
    public void register(IDataSourceInService t) throws ZKException {
        super.doAdd(t);
    }

    @Override
    public void unRegister(String id) throws ZKException {
        super.doRemove(id);
    }

    @Override
    public void update(IDataSourceInService t) throws ZKException {
        super.doUpdate(t);
        IVectorServiceManager vectorServiceManager = this.client.getVectorServiceManager();
        IDataServiceManager dataServiceManager = this.client.getDataServiceManager();
        ArrayList vectorServices = new ArrayList();
        List<Object> dataServices = new ArrayList();
        if (t.getDataSourceType() == Constants.DATA_SOURCE_TYPE.mongodb) {
            QueryFilter cacheFilter = new QueryFilter();
            List cacheServices = vectorServiceManager.list(cacheFilter).stream().filter(vectorService -> vectorService.getStorageInfo() != null).filter(vectorService -> vectorService.getStorageInfo().getBean().getDataSourceId().equals(t.getId())).collect(Collectors.toList());
            vectorServices.addAll(cacheServices);
            cacheFilter = new QueryFilter();
            List cacheList = dataServiceManager.list(cacheFilter).stream().filter(vectorService -> vectorService.getStorageInfo() != null).filter(dataService -> dataService.getStorageInfo().getBean().getDataSourceId().equals(t.getId())).collect(Collectors.toList());
            dataServices.addAll(cacheList);
        } else {
            QueryFilter filter = new QueryFilter();
            filter.addFilter("dataSourceId", Constants.OPERATION.EQ, new Object[]{t.getId()});
            dataServices = dataServiceManager.list(filter);
        }
        List services = vectorServiceManager.list(new QueryFilter());
        List dataVectorServices = dataServices.stream().flatMap(dataService -> services.stream().filter(service -> {
            for (ILayer layer : service.getLayerMap().values()) {
                for (ILayerLevel level : layer.getLevelMap().values()) {
                    if (!((String)dataService.getId()).equals(level.getDataSet().getDataService().getId())) continue;
                    return true;
                }
            }
            return false;
        })).collect(Collectors.toList());
        if (!dataVectorServices.isEmpty()) {
            vectorServices.addAll(dataVectorServices);
        }
        for (int i = 0; i < vectorServices.size(); ++i) {
            vectorServiceManager.update(vectorServices.get(i));
        }
    }

    @Override
    public IScroll<IDataSourceInService> scroll(QueryFilter queryFilter) {
        return super.scroll(queryFilter);
    }

    @Override
    public IDataSourceInService get(String id) {
        return (IDataSourceInService)super.get(id);
    }

    @Override
    public IDataSourceInService findOne(QueryFilter queryFilter) {
        queryFilter.setStart(Integer.valueOf(0));
        queryFilter.setLimit(Integer.valueOf(1));
        List iList = super.list(queryFilter);
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        return (IDataSourceInService)iList.get(0);
    }

    @Override
    public boolean checkVersion(String id, String version) {
        return false;
    }

    @Override
    public void start(String id) throws ZKException {
        throw new NotSupport();
    }

    @Override
    public void stop(String id) throws ZKException {
        throw new NotSupport();
    }

    @Override
    public void rename(String id, String newName) throws ZKException {
        throw new NotSupport();
    }
}

