/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.font;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.exception.NotSupport;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.service.config.Constants;
import com.northpool.service.config.font.FontBuilder;
import com.northpool.service.config.font.IFontService;
import com.northpool.service.dao.font.FontMongoDao;
import com.northpool.service.dao.font.FontZkDao;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FontManager
extends AbstractManager<IFontService, FontBuilder>
implements IFontManager {
    protected static final String MANAGER_ROOT = "font";
    FontMongoDao mongoGridFSDao;

    public FontManager() {
        super(FontBuilder.getInstance(), MANAGER_ROOT);
        this.idFieldName = "filename";
    }

    @Override
    public void init() {
        this.mongoDao = new FontMongoDao(this.client.initMongoClient(), "filename", (FontBuilder)this.beanBuilder);
        this.mongoGridFSDao = (FontMongoDao)this.mongoDao;
        super.init();
        if (this.client.getZoo() != null) {
            this.zkDao = new FontZkDao(this.idFieldName, (FontBuilder)this.beanBuilder, (QueryHashTableHeap<String, IFontService>)this.table, this.client, this.managerRoot, this.readOnly, this, this.mongoDao);
            this.zkDao.init();
        }
    }

    @Override
    public void register(IFontService font) throws ZKException {
        if (((AbstractManager)this).get((String)font.getId()) == null) {
            super.doAdd(font);
        } else {
            super.doUpdate(font);
        }
    }

    @Override
    public void unRegister(String id) throws ZKException {
        super.doRemove(id);
    }

    @Override
    public void unRegister(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType) throws ZKException {
        String id = this.generateFontId(family, style, weight, fileType);
        super.doRemove(id);
    }

    @Override
    public void unRegisterByFamily(String family) throws ZKException {
        if (StringUtils.isEmpty((CharSequence)family)) {
            return;
        }
        QueryFilter filter = new QueryFilter();
        filter.addFilter("family", Constants.OPERATION.EQ, new Object[]{family});
        List<IFontService> list = this.list(filter);
        for (IFontService iFontService : list) {
            this.unRegister((String)iFontService.getId());
        }
    }

    @Override
    public List<IFontService> list(QueryFilter filter) {
        List<IFontService> list = super.list(filter);
        Map<String, List<IFontService>> map = list.stream().collect(Collectors.groupingBy(font -> font.getFamily() + "_" + (Object)((Object)font.getStyle()) + "_" + (Object)((Object)font.getWeight())));
        for (String key : map.keySet()) {
            List<IFontService> flist = map.get(key);
            boolean hasNN = flist.stream().filter(font -> font.getStyle() == Constants.FONT_STYLE.normal && font.getWeight() == Constants.FONT_WEIGHT.normal).findFirst().isPresent();
            if (hasNN) continue;
            list.removeAll(flist);
        }
        return list;
    }

    @Override
    public String map(String idPatternStr, Integer start, Integer limit) {
        QueryFilter filter = new QueryFilter();
        if (StringUtils.isNotEmpty((CharSequence)idPatternStr)) {
            String[] idPatterns = idPatternStr.split(",");
            for (int i = 0; i < idPatterns.length; ++i) {
                String idPattern = idPatterns[i];
                if (i == 0) {
                    filter.addFilter("id", Constants.OPERATION.LFK, new Object[]{idPattern});
                    continue;
                }
                filter.addFilter(Constants.RELATION.OR, "id", Constants.OPERATION.LFK, new Object[]{idPattern});
            }
        }
        List<IFontService> list = this.list(filter);
        Map<String, List<IFontService>> map = list.stream().collect(Collectors.groupingBy(font -> font.getFamily()));
        Iterator<String> iterator = map.keySet().iterator();
        JSONObject obj = new JSONObject();
        while (iterator.hasNext()) {
            String family = iterator.next();
            List<IFontService> familyList = map.get(family);
            Map<String, Map<String, Object>> familymap = familyList.stream().collect(Collectors.groupingBy(font -> (Object)((Object)font.getStyle()) + "_" + (Object)((Object)font.getWeight()), Collectors.toMap(font -> font.getFileType().toString(), font -> font)));
            obj.put(family, familymap);
        }
        return obj.toJSONString();
    }

    @Override
    public IFontService get(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType) {
        String id = this.generateFontId(family, style, weight, fileType);
        IFontService font = (IFontService)super.get(id);
        return font;
    }

    @Override
    public boolean checkVersion(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, String version, Constants.FONT_FILE_TYPE fileType) {
        IFontService font = this.get(family, style, weight, fileType);
        return Objects.equals(version, font.getVersion());
    }

    @Override
    public boolean checkVersion(String id, String version) {
        IFontService font = (IFontService)((AbstractManager)this).get(id);
        return Objects.equals(version, font.getVersion());
    }

    @Override
    public byte[] getContent(String id) {
        byte[] content = this.mongoGridFSDao.getContent((Bson)new Document(this.idFieldName, (Object)id));
        return content;
    }

    @Override
    public String getDefaultFont() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isDefaultFont()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFamily();
        }
        return null;
    }

    @Override
    public String getForeendUnCommon() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isForeendUnCommon()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFamily();
        }
        return null;
    }

    @Override
    public String getBackendUnCommon() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isBackendUnCommon()).findFirst();
        if (optional.isPresent()) {
            return optional.get().getFamily();
        }
        return null;
    }

    @Override
    public String getFontConfig() throws Exception {
        List<IFontService> list = this.list(new QueryFilter());
        Optional<IFontService> optional = list.stream().filter(font -> font.isForeendUnCommon()).findFirst();
        String foreendUnCommon = "";
        if (optional.isPresent()) {
            foreendUnCommon = optional.get().getFamily();
        }
        Set families = list.stream().map(font -> font.getFamily()).collect(Collectors.toSet());
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("foreendUnCommonFont", foreendUnCommon);
        result.put("fonts", families);
        return JSON.toJSONString(result);
    }

    private String generateFontId(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType) {
        return family + "_" + (Object)((Object)style) + "_" + (Object)((Object)weight) + "." + (Object)((Object)fileType);
    }

    @Override
    public void update(IFontService t) throws ZKException {
        throw new NotSupport();
    }

    @Override
    public void start(String id) throws ZKException {
        throw new NotSupport();
    }

    @Override
    public void stop(String id) throws ZKException {
        throw new NotSupport();
    }

    @Override
    public IFontService findOne(QueryFilter queryFilter) {
        throw new NotSupport();
    }

    @Override
    public void rename(String id, String newName) throws ZKException {
        throw new NotSupport();
    }
}

