/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.BasicDBObject;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBuilder;
import com.northpool.service.dao.IMongoDao;
import com.northpool.service.dao.style.StyleMongoDao;
import com.northpool.service.dao.style.StyleZkDao;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.style.StyleInValidException;
import com.northpool.service.mapserver.MapServerAccess;
import com.northpool.service.mapserver.MapserverAccessException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleManager
extends AbstractManager<IStyleService, StyleBuilder>
implements IStyleManager {
    Logger logger = LoggerFactory.getLogger(StringBuilder.class);
    protected static final String MANAGER_ROOT = "style";
    protected MapServerAccess mapServerAccess;

    public StyleManager() {
        super(StyleBuilder.getInstance(), MANAGER_ROOT);
        this.idFieldName = "uuid";
    }

    @Override
    public void init() {
        this.mongoDao = new StyleMongoDao(this.client.initMongoClient(), this.idFieldName, (StyleBuilder)this.beanBuilder);
        super.init();
        this.mapServerAccess = this.client.getMapServerAccess();
        if (this.client.getZoo() != null) {
            this.zkDao = new StyleZkDao(this.idFieldName, (StyleBuilder)this.beanBuilder, (QueryHashTableHeap<String, IStyleService>)this.table, this.client, this.managerRoot, this.readOnly, this, this.mongoDao);
            this.zkDao.init();
        }
    }

    @Override
    public void save(IStyleService style) throws ZKException {
        IStyleService finalStyle = style;
        String result = null;
        try {
            result = MapServerAccess.saveStyle(finalStyle.getOwnServer(), finalStyle.getName(), finalStyle.getStyleJson(), finalStyle.getXmin(), finalStyle.getYmin(), finalStyle.getXmax(), finalStyle.getYmax());
        }
        catch (MapserverAccessException e) {
            throw new CompletionException(e);
        }
        this.logger.debug(result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!(resultJson.containsKey((Object)"success") && resultJson.get((Object)"success").equals(true) && resultJson.containsKey((Object)"id"))) {
            throw new CompletionException(new StyleInValidException(resultJson.getString("message")));
        }
        BasicDBObject filter = new BasicDBObject();
        filter.put((Object)"name", (Object)style.getName());
        filter.put((Object)"ownServer", (Object)style.getOwnServer());
        style = (IStyleService)this.mongoDao.findone((Bson)filter);
        int maxTry = 3;
        for (int count = 0; style == null && count < maxTry; ++count) {
            style = (IStyleService)this.mongoDao.findone((Bson)filter);
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                if (count != maxTry) continue;
                e.printStackTrace();
                throw new ZKException("\u83b7\u5f97mongodb\u6570\u636e\u8d85\u8fc7\u6700\u5927\u5c1d\u8bd5\u6b21\u6570");
            }
        }
        if (this.get((String)style.getId()) == null) {
            if (this.zkDao != null) {
                this.saveBeanToHashTable(style);
                try {
                    this.zkDao.saveBeanTozk(style);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.removeBeanToHashTable((String)style.getId());
                    throw new ZKException(e);
                }
            }
        } else if (this.zkDao != null) {
            this.table.update((Object)style);
            this.zkDao.updateBeanTozk(style);
        }
    }

    @Override
    public void remove(String[] ids) throws ZKException {
        for (int i = 0; i < ids.length; ++i) {
            try {
                super.doRemove(ids[i]);
                continue;
            }
            catch (NotFoundException e) {
                this.logger.info(e.getMessage());
            }
        }
    }

    @Override
    public IStyleService get(String belongService, String styleId) {
        return (IStyleService)super.get(belongService + "_" + styleId);
    }

    @Override
    public boolean checkVersion(String belongService, String styleId, String version) {
        IStyleService style = this.get(belongService, styleId);
        if (style != null) {
            return Objects.equals(version, style.getVersion());
        }
        return false;
    }

    @Override
    public void update(IStyleService style) throws ZKException {
        this.remove(new String[]{style.getUuid()});
        style.getBean().setUuid(style.getOwnServer() + "_" + style.getName());
        this.doAdd(style);
    }

    public IMongoDao<IStyleService> getMongoDao() {
        return this.mongoDao;
    }
}

