/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.texture;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.Jsonable;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.service.config.texture.ITextureService;
import com.northpool.service.config.texture.TextureBuilder;
import com.northpool.service.dao.texture.TextureMongoDao;
import com.northpool.service.dao.texture.TextureZkDao;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TextureManager
extends AbstractManager<ITextureService, TextureBuilder>
implements ITextureManager {
    protected static final String MANAGER_ROOT = "texture";

    public TextureManager() {
        super(TextureBuilder.getInstance(), MANAGER_ROOT);
    }

    @Override
    public void init() {
        this.mongoDao = new TextureMongoDao(this.client.initMongoClient(), (TextureBuilder)this.beanBuilder);
        super.init();
        if (this.client.getZoo() != null) {
            this.zkDao = new TextureZkDao(this.idFieldName, (TextureBuilder)this.beanBuilder, (QueryHashTableHeap<String, ITextureService>)this.table, this.client, this.managerRoot, this.readOnly, this.mongoDao);
            this.zkDao.init();
        }
    }

    @Override
    public void add(List<ITextureService> textures) throws ZKException {
        int i2;
        ITextureService texture = null;
        HashSet<String> inValidNames = new HashSet<String>();
        for (i2 = 0; i2 < textures.size(); ++i2) {
            texture = textures.get(i2);
            if (texture.isValid()) continue;
            inValidNames.add(texture.getName());
        }
        if (!inValidNames.isEmpty()) {
            String i2 = StringUtils.join(inValidNames, (String)",");
        }
        for (i2 = 0; i2 < textures.size(); ++i2) {
            texture = textures.get(i2);
            super.doAdd((Jsonable)textures.get(i2));
        }
    }

    @Override
    public void remove(String[] ids) throws ZKException {
        for (int i = 0; i < ids.length; ++i) {
            super.doRemove(ids[i]);
        }
    }

    @Override
    public String list(String ids) {
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return "[]";
        }
        QueryFilter filter = new QueryFilter();
        filter.addFilter(this.idFieldName, Constants.OPERATION.IN, (Object[])ids.split(","));
        List texturesList = this.list(filter);
        List textureBeans = texturesList.stream().map(texture -> texture.getBean()).collect(Collectors.toList());
        return JSON.toJSONString(textureBeans);
    }
}

