package com.northpool.service;

import com.northpool.commons.classloader.MemoryClassLoader;
import com.northpool.commons.reflect.Reflect;
import com.northpool.commons.util.FileUtil;
import com.northpool.service.client.Client;
import com.northpool.service.netty.websocket.WebSocketServer;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClientMain {

    MemoryClassLoader loader;

    Object client;

    Class clientClass;

    public ClientMain(String path, Object[] info) throws IOException, ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        String curPath = path;
        //CustomClassLoader customClassLoader = CustomClassLoader.getCustomClassLoader(Thread.currentThread().getContextClassLoader().getParent());
       // this.loader = new MemoryClassLoader(customClassLoader);
        this.loader = new MemoryClassLoader();
        //customClassLoader.setLoader(this.loader);
        Thread.currentThread().setContextClassLoader(loader);
        
        for(int i = 0; i < info.length / 2 ; i ++){
            loader.loadJar((String)info[i * 2], (byte[])info[(i * 2) + 1]);
        }

        Reflect.setClassLoader(loader);
        
        System.setProperty("APP_HOME", curPath);

    }

    public Object init(String mongoUri, String zkAddress, String mapserverUrl, Integer tcpPort) throws Exception {
        Thread.currentThread().setContextClassLoader(loader);
        this.clientClass = this.loader.loadClass("com.northpool.service.client.Client");
/*        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("conf/app-context.xml");
        AppUtil.appContext = ctx;*/
        Constructor constructor = clientClass.getDeclaredConstructor(String.class, String.class, String.class);
        this.client = constructor.newInstance(mongoUri, zkAddress, mapserverUrl);
        new WebSocketServer((Client) this.client).bind(tcpPort);
        return this.client;
    }

    public Object getTextureManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTextureManager");
        return method.invoke(this.client);
    }

    public Object getVectorServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException{
        Method method = this.clientClass.getMethod("getVectorServiceManager");
        return method.invoke(this.client);
    }


    public Object getDataSourcesManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException{
        Method method = this.clientClass.getMethod("getDataSourcesManager");
        return method.invoke(this.client);
    }

    public Object getDataServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException{
        Method method = this.clientClass.getMethod("getDataServiceManager");
        return method.invoke(this.client);
    }

    public Object getStyleManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getStyleManager");
        return method.invoke(this.client);
    }

    public Object getFontManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getFontManager");
        return method.invoke(this.client);
    }

    public Object getTileDataCellManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTileDataCellManager");
        return method.invoke(this.client);
    }
    
    
    
    public static void main(String[] aaa) throws Exception, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException{
		byte[] b = FileUtil.File2byte("C:\\test\\vector_cut_cell-0.0.4-SNAPSHOT.jar");
		ClientMain nodeJavaBridge = new ClientMain("C:\\gitcode\\mapserverManager3.x\\service-client\\target\\classes", new Object[]{"VectorService-1.2.5.1.jar",b});
		
	
		nodeJavaBridge.init("mongodb://127.0.0.1:27017/osmxuyuan","127.0.0.1:2181", "http://127.0.0.1:81/mapserver", 20001);
		
		System.out.println(nodeJavaBridge.getTileDataCellManager());
		
		//nodeJavaBridge.register("c:/tilexml/政务网_7-20级_省参.xml", true);
		 
		//nodeJavaBridge.init("127.0.0.1", 27017, null, null, "managet11", 20);
		//System.out.println(nodeJavaBridge.getDataRealTime("dltb2015",6599, 1600, 13, null, "vector"));
		
		//System.out.println(new String(nodeJavaBridge.getDataSetDataCount("zjvmap", "面状植被", null, null, null, null, null)));
		//System.out.println(new String(nodeJavaBridge.getDataSetInfo("zjvmap", "面状植被", null)));
	
		
		//System.out.println(new String(nodeJavaBridge.getDataSetData("zjvmap", "面状植被", null, null, null, "1", null, null,null)));
		//System.out.println(new String(nodeJavaBridge.getDataRealTime("f7816862e6d648a195e454003e8a84dc","tdt_degrees_512",213,43, 9, null, "vector"),"utf-8"));
	}

    

    


}
