package com.northpool.service.config.data_service;


import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.client.Client;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;

public class DataServiceBuilder implements JsonableBuilder<IDataService>, DocumentableBuilder<IDataService> {

	private Client client;

	public DataServiceBuilder(){


	}
	public DataServiceBuilder(Client client){
		this.client = client;
	}
	
	/*public static DataServiceBuilder getInstance(Client client){
		return new DataServiceBuilder(client);
	}*/
	
	@Override
	public IDataService fromJson(String json) throws Exception {
	
		DataServiceBean dataService = JSON.parseObject(json, DataServiceBean.class);
		if (dataService.getId() == null){//没有id的认为是异常数据，返回空
			return null;
		}
		DataServiceShell shell = new DataServiceShell(this.client,dataService);
		
		return shell;
	}

	@Override
	public IDataService fromDocument(Document str) throws Exception {
		str.remove("_id");
		return this.fromJson(str.toJson());
	}

	public void setClient(Client client) {
		this.client = client;
	}
}
