package com.northpool.service.config.data_service.tileInfo;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;

public class AreaTileInfoShell implements IAreaTileInfo {

    AreaTileInfoBean bean;

    IStorageInfo storageInfo;

    public AreaTileInfoShell(Client client, AreaTileInfoBean bean) {
        this.bean = bean;
        StorageInfoBean storageInfoBean = bean.getStorageInfo();
        if (storageInfoBean != null){
            this.storageInfo = new StorageInfoShell(client, storageInfoBean);
        }
    }

    @Override
    public IDataSourceInService getDataSource() {
        return this.storageInfo.getDataSource();
    }

    @Override
    public AreaTileInfoBean getBean() {
        return bean;
    }


    @Override
    public String getStorageName() {
        return this.storageInfo.getStorageName();
    }

    @Override
    public Integer getStartLevel() {
        return this.storageInfo.getStartLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.storageInfo.getEndLevel();
    }

    @Override
    public void drop() {
        if (this.storageInfo != null){
            this.storageInfo.drop();
        }
    }

    public IStorageInfo getStorageInfo() {
        return storageInfo;
    }

    public void setStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.bean.setStorageInfo(storageInfo.getBean());
    }
}
