package com.northpool.service.config.vector_service.dataset;

import java.util.Map;

import com.northpool.resources.datatable.IField;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.spatial.Constants.GEO_TYPE;
/**
 * 矢量瓦片数据集接口
 * @author matt
 *
 */
public interface IDataSet {
	
	/**
	 * 过滤条件
	 * @return
	 */
	public String getFilter();
	/**
	 * 排序字段
	 * @return
	 */
	public String getSortFiled();
	/**
	 * 排序规则 ASC DESC
	 * @return
	 */
	public String getSort();
	/**
	 * 空间过滤条件
	 * @return
	 */
	public String getSpatialFilter();
	/**
	 * 字段集合
	 * @return
	 */
	public Map<String, IField> getFieldsMap();
	/**
	 * 主键字段
	 * @return
	 */
	public String getIdField();
	
	/**
	 * 空间字段
	 * @return
	 */
	public String getSpatialField();
	
	/**
	 * 图形的类型
	 * @return
	 */
	public GEO_TYPE getGeometryType();
	
	/**
	 * 获得数据源
	 * @return
	 */
	public IDataSourceInService getDataSource();
	/**
	 * 获得所有的字段
	 * @return
	 */
	public String[] getFieldsArr();

	public IDataService getDataService();
	
}
