package com.northpool.service.dao;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;

import java.util.List;

public class AbtractServiceZkDao<T extends Jsonable & Idable<String> & IDocumentAble & CanStartStop,Builder extends JsonableBuilder<T>> extends AbstractZkDao<T,Builder> {

    protected static final String STATS_TYPE_NAME = "stats";

    public AbtractServiceZkDao(String idFieldName, Builder beanBuilder, QueryHashTableHeap<String, T> table, Client client, String managerRoot, Boolean readOnly, IMongoDao<T> mongoDao) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly, mongoDao);
    }

    @Override
    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, T t) throws Exception {
        // TODO Auto-generated method stub
        CuratorOp createOp = transaction.create().forPath(path + "/" + STATS_TYPE_NAME,t.state().getBytes());
        iList.add(createOp);
    }

    protected void sycnStatus2Zk(String id,T t) throws ZKException {
        String path = this.path(id);
        try {
            if(!this.exists(id)){
                throw new ZKException("ZK数据错误,ZK中找不到" + id + " path:" + path + " 节点");
            }

            String typeId = id + "/" + STATS_TYPE_NAME;
            if(!this.exists(typeId)){
                throw new ZKException("ZK数据错误,ZK中找不到" + id + " path:" + typeId + " 状态节点");
            }
            this.client.getZoo().setData().forPath(typeId,t.state().getBytes());
        } catch (Exception e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            throw new ZKException(e);
        }
    }
}
