package com.northpool.service.dao.style;

import com.northpool.service.client.Client;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBuilder;
import com.northpool.service.dao.AbstractZkDao;
import com.northpool.service.dao.IMongoDao;
import com.northpool.service.manager.IClientManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

public class StyleZkDao extends AbstractZkDao<IStyleService, StyleBuilder> {

    Logger logger = LoggerFactory.getLogger(StyleZkDao.class);

    protected IMongoDao<IStyleService> mongoDao;

    public StyleZkDao(String idFieldName, StyleBuilder beanBuilder, QueryHashTableHeap<String, IStyleService> table, Client client, String managerRoot, Boolean readOnly, IClientManager manager, IMongoDao<IStyleService> mongoDao) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly, mongoDao);
        this.manager = manager;
        this.mongoDao = manager.getMongoDao();
    }

/*    protected List<CuratorOp> createBeanNode(TransactionOp transaction, IStyleService t) throws Exception{
        String id = t.getId();
        String path = this.path(id);
        List<CuratorOp> iList = new ArrayList<CuratorOp>();
        CuratorOp createOp1 = transaction.create().withMode(CreateMode.PERSISTENT).forPath(path,id.getBytes("utf-8"));
        iList.add(createOp1);
        CuratorOp createOp2 = transaction.create().forPath(path + "/id",t.getId().getBytes("utf-8"));
        iList.add(createOp2);
        JSONObject obj = (JSONObject) JSON.toJSON(t.getBean());//去掉体积较大的字段，免得zk放不下
        obj.remove("styleJson");
        obj.remove("styleLayerJs");
        obj.remove("styleLabelJs");
        obj.remove("styleAvoidjs");
        obj.remove("queryLayer");
        obj.remove("queryLabel");
        obj.remove("mapboxStyle");
        CuratorOp createOp3 = transaction.create().forPath(path + "/data",obj.toJSONString().getBytes("utf-8"));
        iList.add(createOp3);
        this.AddExtendsInfo2BeanNode(path, iList, transaction, t);
        return iList;
    }*/

/*    public IStyleService getFromZK(String id) throws Exception{
        return this.getFromMongo(id);
    }*/

    @Override
    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, IStyleService iStyleService) throws Exception {
    	
    }
}
