package com.northpool.service.manager.style;

import com.northpool.resources.command.QueryFilter;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.abstractclass.ZKException;

import java.util.List;

public interface IStyleManager extends IClientManager {
    public void save(IStyleService style) throws ZKException;

    public void remove(String[] ids) throws ZKException;

    public IStyleService get(String belongService, String styleId);

    public boolean checkVersion(String belongService, String styleId, String version);

    public String getJSON(String id);

    /**
     * 应对样式内容没有修改，只是所属服务等元数据信息修改
     * @param style
     */
    public void update(IStyleService style) throws ZKException;

    public List<IStyleService> list(QueryFilter filter) ;
}
