package com.northpool.service.manager.texture;

import com.alibaba.fastjson.JSON;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.service.config.texture.ITextureService;
import com.northpool.service.config.texture.TextureBean;
import com.northpool.service.config.texture.TextureBuilder;
import com.northpool.service.dao.texture.TextureMongoDao;
import com.northpool.service.dao.texture.TextureZkDao;
import com.northpool.service.manager.abstractclass.*;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TextureManager  extends AbstractManager<ITextureService, TextureBuilder> implements ITextureManager {

    protected static final String MANAGER_ROOT = "texture";



    public TextureManager(){
        super(TextureBuilder.getInstance(), MANAGER_ROOT);

    }

    public void init(){
        this.mongoDao = new TextureMongoDao(client.initMongoClient(),  beanBuilder);
        super.init();
        if (client.getZoo() != null) {
            this.zkDao = new TextureZkDao(idFieldName, beanBuilder, table, client, managerRoot, readOnly, this.mongoDao);
            this.zkDao.init();
        }
    }

    @Override
    public void add(List<ITextureService> textures) throws ZKException {
        ITextureService texture = null;
        Set<String> inValidNames = new HashSet<>();
        for (int i = 0; i < textures.size(); i++) {
            texture = textures.get(i);
            if (!texture.isValid()){
                inValidNames.add(texture.getName());
            }
        }
        if (!inValidNames.isEmpty()){//检查不符合要求的符号，批量抛出异常
            String names = StringUtils.join(inValidNames, ",");
            //throw new TextureInValidException("符号 " + names + " 不符合要求！");
        }

        for (int i = 0; i < textures.size(); i++) {
            texture = textures.get(i);
            super.doAdd(textures.get(i));
        }
    }

    @Override
    public void remove(String[] ids) throws ZKException {
        for (int i = 0; i < ids.length; i++) {
            super.doRemove(ids[i]);
        }
    }

    @Override
    public String list(String ids)  {
        if(StringUtils.isEmpty(ids)){
            return "[]";
        }
        QueryFilter filter = new QueryFilter();
        filter.addFilter(this.idFieldName, Constants.OPERATION.IN, ids.split(","));
        List<ITextureService> texturesList = this.list(filter);
        List<TextureBean> textureBeans = texturesList.stream().map(texture -> texture.getBean()).collect(Collectors.toList());
        return JSON.toJSONString(textureBeans);
    }

    @Override
    public List<ITextureService> listTextures(String[] ids)  {
        if(ids == null || ids.length == 0){
            return null;
        }
        QueryFilter filter = new QueryFilter();
        filter.addFilter(this.idFieldName, Constants.OPERATION.IN, ids);
        List<ITextureService> texturesList = this.list(filter);
        return texturesList;
    }


}
