package com.northpool.service.config.data_source;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.service.client.Client;
import org.bson.Document;

public class DataScourceShell implements IDataSourceInService {
	protected com.northpool.resources.datasource.IDataSource dataSource;
	protected String name;
	protected String id;
	public static final String SHELL_ID = "shellid";
	public static final String NAME = "name";
	public static final String ID = "id";

	private Client client;

	protected String mark;

	public String getMark() {
		return mark;
	}

	public DataScourceShell(Client client, String name, String id, com.northpool.resources.datasource.IDataSource dataSource){
		this.client = client;
		this.name = name;
		this.id = id;
		this.dataSource = dataSource;
		this.mark = dataSource.mark();
	}
	
	@Override
	public DATA_SOURCE_TYPE getDataSourceType() {
		// TODO Auto-generated method stub
		return dataSource.getDataSourceType();
	}

	@Override
	public <ConnectionPool> ConnectionPool connection() throws Exception {
		// TODO Auto-generated method stub
		return dataSource.connection();
	}
	@Override
	public void resetConnection() {
		// TODO Auto-generated method stub
		dataSource.resetConnection();
	}
	@Override
	public void destory() {
		// TODO Auto-generated method stub
		dataSource.destory();
	}
	@Override
	public ITableOperator getTableBuilder(String tableName) throws Exception {
		// TODO Auto-generated method stub
		return dataSource.getTableOperator(tableName);
	}
	@Override
	public String toJson() {
		// TODO Auto-generated method stub
		JSONObject object = (JSONObject) JSON.toJSON(this.dataSource);
		object.put(SHELL_ID, id);
		object.put(NAME, this.name);
		object.put(ID, this.id);
		return object.toJSONString();
	}
	
	public com.northpool.resources.datasource.IDataSource getDataSource() {
		return dataSource;
	}
	public void setDataSource(com.northpool.resources.datasource.IDataSource dataSource) {
		this.dataSource = dataSource;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	@Override
	public String mark() {
		// TODO Auto-generated method stub
		return dataSource.mark();
	}
	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return id;
	}

	@Override
	public IDataSource getBean() {
		// TODO Auto-generated method stub
		return this.dataSource;
	}

	@Override
	public void testConnection() throws Exception {
		// TODO Auto-generated method stub
		this.dataSource.testConnection();
	}

	@Override
	public void refresh() {
		IDataSourceInService dataSourceInService = this.client.getDataSourcesManager().get(this.id);
		if (dataSourceInService == null){
			return;//此处应抛出异常
		}
		this.dataSource = dataSourceInService.getBean();
		this.mark = this.dataSource.mark();
	}

	@Override
	public Document toDocument() {
		return Document.parse(this.toJson());
	}

	@Override
	public boolean equals(Object o){
		IDataSourceInService dataSource = (IDataSourceInService) o;
		return this.dataSource.equals(dataSource.getBean());
	}

	@Override
	public String getVersion() {
		return this.dataSource.getVersion();
	}

	@Override
	public void setVersion(String version) {
		this.dataSource.setVersion(version);
	}
}
