package com.northpool.service.config.data_source;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.bean.JsonableBuilder;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;

public class DataSourceBuilder implements JsonableBuilder<IDataSourceInService>, DocumentableBuilder<IDataSourceInService> {

	private Client client;

	private static DataSourceBuilder _DATA_SOURCE_BUILDER = new DataSourceBuilder();

	public static DataSourceBuilder getInstance() {
		return _DATA_SOURCE_BUILDER;
	}
	
	public final static String DATA_SOURCE_TYPE_FILED = "dataSourceType";

	public DataSourceBuilder(){

	}

	public DataSourceBuilder(Client client){
		this.client = client;
	}

	public IDataSourceInService fromJson(String json) throws Exception {
		JSONObject object = JSON.parseObject(json);
		String name = object.getString(DataScourceShell.NAME);
		String shellid = object.getString(DataScourceShell.SHELL_ID);
		com.northpool.resources.datasource.IDataSource dataSource = IDataSource.fromJSON(json);
		if (dataSource.getId() == null){//没有id的认为是异常数据，返回空
			return null;
		}
		return new DataScourceShell(this.client, name,shellid,dataSource);
		
	}

	@Override
	public IDataSourceInService fromDocument(Document str) throws Exception {
		str.remove("_id");
		return this.fromJson(str.toJson());
	}

	public void setClient(Client client) {
		this.client = client;
	}
}
