package com.northpool.service.config.data_source;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.Markable;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.service.client.Client;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.config.IVersionAble;

public interface IDataSourceInService extends Jsonable, Markable, Idable<String>, IDocumentAble, IVersionAble {
	
	public String getName();
	
	public DATA_SOURCE_TYPE getDataSourceType();

	public final static String DATA_SOURCE_TYPE_FILED = "dataSourceType";
	
	public <ConnectionPool> ConnectionPool connection()  throws Exception;
	
	public void resetConnection();
	
	public void destory();
	
	public ITableOperator getTableBuilder(String tableName) throws Exception;
	
	public String getId();
	
	public IDataSource getBean();

	public void testConnection() throws Exception;
	
	public static IDataSourceInService create(Client client, String id, String name, IDataSource dataSource){
		return new DataScourceShell(client, name, id, dataSource);
	}

    void refresh();
}
