package com.northpool.service.config.style;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import org.bson.Document;
import org.bson.types.Binary;

import java.util.List;

public class StyleBuilder implements JsonableBuilder<IStyleService>, DocumentableBuilder<IStyleService> {

    private static StyleBuilder _STYLE_BUILDER = new StyleBuilder();

    public static StyleBuilder getInstance() {
        return _STYLE_BUILDER;
    }

    @Override
    public IStyleService fromJson(String json) throws Exception{
        StyleBean styleBean = JSON.parseObject(json, StyleBean.class);
        return new StyleShell(styleBean);
    }

    @Override
    public IStyleService fromDocument(Document doc){
        StyleBean style = new StyleBean();
        style.setOwnServer((String) doc.get("ownServer"));
        style.setName((String) doc.get("name"));
        style.setStyleJson((String) doc.get("styleJson"));
        style.setVersion((String) doc.get("version"));
        style.setUuid((String) doc.get("uuid"));
        @SuppressWarnings("unchecked")
		List<String> extFonts = (List<String>) doc.get("extFonts");
        if (extFonts != null){
            String[] extFontsArr = extFonts.toArray(new String[extFonts.size()]);
            style.setExtFonts(extFontsArr);
        }

        @SuppressWarnings("unchecked")
		List<String> textureLabel = (List<String>) doc.get("textureLabel");
        if (textureLabel != null){
            String[] textureLabelArr = textureLabel.toArray(new String[textureLabel.size()]);
            style.setTextureLabel(textureLabelArr);
        }

        @SuppressWarnings("unchecked")
		List<String> textureLayer = (List<String>) doc.get("textureLayer");
        if (textureLayer != null){
            String[] textureLayerArr = textureLayer.toArray(new String[textureLayer.size()]);
            style.setTextureLayer(textureLayerArr);
        }
        style.setStyleLabelJs(((Binary) doc.get("styleLabelJs")).getData());
        style.setStyleLayerJs(((Binary) doc.get("styleLayerJs")).getData());
        style.setStyleAvoidjs(((Binary) doc.get("styleAvoidjs")).getData());
        if (doc.get("queryLayer") != null){
            style.setQueryLayer(((Binary) doc.get("queryLayer")).getData());
        }

        if (doc.get("queryLabel") != null){
            style.setQueryLabel(((Binary) doc.get("queryLabel")).getData());
        }

        if (doc.get("mapboxStyle") != null){
            style.setMapboxStyle(((Binary) doc.get("mapboxStyle")).getData());
        }

        if (doc.get("xmin") != null){
            style.setXmin((Double) doc.get("xmin"));
            style.setYmin((Double) doc.get("ymin"));
            style.setXmax((Double) doc.get("xmax"));
            style.setYmax((Double) doc.get("ymax"));
        }
        return new StyleShell(style);
    }
}
