package com.northpool.service.config.style.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.northpool.service.config.style.style.style.*;

import java.lang.reflect.Type;
import java.util.Map;

//fastjson
@JSONType(deserializer = Style.StyleDeserializer.class)
public class Style extends AbstractStyle {
    private String data;
    private String query;
    private String labelType;
    private String nodeUid;
    private String filter;
    private String isVisbile;
    private Map<String,String> avoid;

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getLabelType() {
        return labelType;
    }

    public void setLabelType(String labelType) {
        this.labelType = labelType;
    }

    public String getNodeUid() {
        return nodeUid;
    }

    public void setNodeUid(String nodeUid) {
        this.nodeUid = nodeUid;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getIsVisbile() {
        return isVisbile;
    }

    public void setIsVisbile(String isVisbile) {
        this.isVisbile = isVisbile;
    }

    public Map<String,String> getAvoid() {
        return avoid;
    }

    public void setAvoid(Map<String,String> avoid) {
        this.avoid = avoid;
    }

    public static class StyleDeserializer implements ObjectDeserializer {

        @SuppressWarnings("unchecked")
		@Override
        public Style deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            JSONObject jsonObject = parser.parseObject();
            if ("line".equals(jsonObject.getString("iconType"))) {
                return JSON.parseObject(jsonObject.toJSONString(), LineStyle.class);// jsonObject.toJavaObject(LineStyle.class);
            } else if ("line-label".equals(jsonObject.getString("iconType"))) {
                return JSON.parseObject(jsonObject.toJSONString(), LineLabelStyle.class);//jsonObject.toJavaObject(LineLabelStyle.class);
            } else if ("polygon".equals(jsonObject.getString("iconType"))) {
                return JSON.parseObject(jsonObject.toJSONString(), PolygonStyle.class);//jsonObject.toJavaObject(PolygenStyle.class);
            } else if ("point-mark".equals(jsonObject.getString("iconType"))) {
                return JSON.parseObject(jsonObject.toJSONString(), PointStyle.class);//jsonObject.toJavaObject(PointStyle.class);
            } else {
                return JSON.parseObject(jsonObject.toJSONString(), PointLabelStyle.class);//jsonObject.toJavaObject(PointLabelStyle.class);
            }
        }

        @Override
        public int getFastMatchToken() {
            return 0;
        }
    }

}
