package com.northpool.service.manager.abstractclass;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.service.manager.IClientManager;

import java.util.List;

public interface IServiceManager<T>  extends IClientManager {
	public List<T> list(QueryFilter queryFilter);
	public void register(T t)  throws ZKException;
	public void unRegister(String id) throws ZKException;
	public void update(T t) throws ZKException ;
	public void start(String id) throws ZKException;
	public void stop(String id) throws ZKException;
	public IScroll<T> scroll(QueryFilter queryFilter);
	public T get(String id);
	public T findOne(QueryFilter queryFilter);
	public String getJSON(String id);
	public void rename(String id, String newName) throws ZKException;

}
