package com.northpool.service.manager.abstractclass;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.exception.UException;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.CanStartStop.STATE_TYPE;
import com.northpool.service.config.IDocumentAble;

public abstract class ServiceManager<T extends Jsonable & Idable<String> & IDocumentAble & CanStartStop,Builder extends JsonableBuilder<T> & DocumentableBuilder<T>> extends AbstractManager<T,Builder> {

	public ServiceManager(Builder beanBuilder, String managerRoot) {
		super(beanBuilder, managerRoot);
	}
	
	protected T startBean2Table(String id){
		T t = this.get(id);
		if(t == null){
			throw new NotFoundException(id);
		}
		t.start();
		return t;
	}
	
	protected T stopBean2Table(String id){
		T t = this.get(id);
		if(t == null){
			throw new NotFoundException(id);
		}
		t.stop();
		return t;
	}
	

	
	protected void rollback2Table(String id,STATE_TYPE state) throws NotFoundException{
		T t = this.get(id);
		if(t == null){
			throw new NotFoundException(id);
		}
		t.rollback(state);
	}
	
	/**
	 * 启动服务
	 * @param id
	 * @throws ZKException
	 * @throws IdFieldValueEmptyException
	 * @throws NotReadyException
	 * @throws NotFoundException
	 */
	public void start(String id) throws ZKException  {
		T t = this.startBean2Table(id);
		try {
			this.doUpdate(t);
			this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.start.name(), id,t);
		} catch (ZKException e) {
			// TODO Auto-generated catch block
			UException.printStackTrace(e);
			this.rollback2Table(id,STATE_TYPE.stop);
			throw e;
		}
	}

	/**
	 * 停止服务
	 * @param id
	 * @throws ZKException
	 * @throws IdFieldValueEmptyException
	 * @throws NotReadyException
	 * @throws NotFoundException
	 */
	public void stop(String id) throws ZKException {
		T t = this.stopBean2Table(id);
		try {
			this.doUpdate(t);
			this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.stop.name(), id,t);
		} catch (ZKException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			this.rollback2Table(id,STATE_TYPE.run);
			throw e;
		}
	}

	

	

}
