package com.northpool.service.config.data_service.tileInfo;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;

public class FeatureTileInfoShell implements IFeatureTileInfo {

    FeatureTileInfoBean bean;

    IStorageInfo storageInfo;

    public FeatureTileInfoShell(Client client, FeatureTileInfoBean bean) {
        this.bean = bean;
        StorageInfoBean storageInfoBean = bean.getStorageInfo();
        if (storageInfoBean != null){
            this.storageInfo = new StorageInfoShell(client, storageInfoBean);
        }
    }

    @Override
    public IDataSourceInService getDataSource() {
        return this.storageInfo.getDataSource();
    }

    @Override
    public FeatureTileInfoBean getBean() {
        return bean;
    }


    @Override
    public Integer getLevel() {
        return this.bean.getLevel();
    }

    @Override
    public String[] getGroupFields() {
        return bean.getGroupFields();
    }

    @Override
    public String getAreaField() {
        return bean.getAreaField();
    }

    @Override
    public String getStorageName() {
        return this.storageInfo.getStorageName();
    }


    @Override
    public void drop() {
        if (this.storageInfo != null){
            this.storageInfo.drop();
        }
    }

    public IStorageInfo getStorageInfo() {
        return storageInfo;
    }

    public void setStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.bean.setStorageInfo(storageInfo.getBean());
    }
}
