/**
　 * <p>Title: IRasterService.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*/
package com.northpool.service.config.raster_service;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.Markable;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.config.IService;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.config.raster_service.layer.IRasterLayer;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.spatial.grid.Grid;

/**
 * @author chy
 *
 */
public interface IRasterService extends IService, Jsonable, Markable, Idable<String>,
            IDocumentAble, CanStartStop, ICacheable, IVersionAble {
    
    /**
     * ID
     * @return
     */
    public String getId();
    /**
     * 名称
     * @return
     */
    public String getName();
    /**
     * 更新版本号
     * @return
     */
    public String getVersion();
    /**
     * GRID
     * @return
     */
    public Grid getGridTree();
    /**
     * 四至范围
     * @return
     */
    public String getBbox();
    /**
     * 开始级别
     * @return
     */
    public Integer getBeginLevel();
    /**
     * 结束级别
     * @return
     */
    public Integer getEndLevel();
    
    /**
     * 获得所有的图层
     * @return
     */
    public LinkedHashMap<String, IRasterLayer> getLayerMap();
    
    /**
     * 是否是单图层服务
     * @return
     */
    public Boolean isSinglelayer();
    
    /**
     * 是否允许缓存
     * @return
     */
    public Boolean allowCache();
    
    public RasterServiceBean getBean();
    
    public Client getClient();

    public void refresh();

    public void addCacheInfo(ICacheable cacheInfo);

    public ICacheable getCacheInfo();

    public IStorageInfo getStorageInfo();

    public int[] getOrigin();

    public double[] getResolutions();

    public List<String> getDataServiceIds();
}
