/**
　 * <p>Title: RasterServiceBean.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*/
package com.northpool.service.config.raster_service;

import java.util.LinkedHashMap;
import java.util.Map;

import com.northpool.service.config.CanStartStop.STATE_TYPE;
import com.northpool.service.config.Constants.SERVICE_TYPE;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.layer.RasterLayerBean;
import com.northpool.service.config.vector_service.CacheInfoBean;

/**
 * @author chy
 *
 */
public class RasterServiceBean {
    /**
     * ID
     */
    private String id;
    /**
     * 名称
     */
    private String name;
    /**
     * 四至范围
     */
    private String bbox;
    /**
     * 更新版本
     */
    private String version;
    /**
     * 格网
     */
    private String gridTreeName;

    private double[] resolutions;

    private int[] origin;
    /**
     * 数据集map
     */
    private Map<String, RasterDataSetBean> dataSetMap;
    /**
     * 图层
     */
    private LinkedHashMap<String, RasterLayerBean> layerMap;
    /**
     * 开始等级
     */
    private Integer beginLevel;
    /**
     * 结束等级
     */
    private Integer endLevel;
    
    /**
     * 图片缓存信息
     */
    private CacheInfoBean cacheInfo;

    /**
     * 服务状态，包含：run运行、stop停止、standby备用
     */
    private STATE_TYPE state = STATE_TYPE.standby;
    /**
     * 服务类型
     */
    private SERVICE_TYPE serviceType;
    /**
     * 波段值转为RGBA脚本
     */
    private String bandValueToRGBAScript;
    /**
     * 影像文件合并脚本
     */
    private String mergeScript;

    private RasterServiceBean(SERVICE_TYPE serviceType) {
        this.serviceType = serviceType;
    }
    
    public static RasterServiceBean initImage() {
        return new RasterServiceBean(SERVICE_TYPE.image_service);
    }
    
    public static RasterServiceBean initTerrain() {
        return new RasterServiceBean(SERVICE_TYPE.terrain_service);
    }
    
    RasterServiceBean(){}
    
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBbox() {
        return bbox;
    }

    public void setBbox(String bbox) {
        this.bbox = bbox;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGridTreeName() {
        return gridTreeName;
    }

    public void setGridTreeName(String gridTreeName) {
        this.gridTreeName = gridTreeName;
    }

    public double[] getResolutions() {
        return resolutions;
    }

    public void setResolutions(double[] resolutions) {
        this.resolutions = resolutions;
    }

    public int[] getOrigin() {
        return origin;
    }

    public void setOrigin(int[] origin) {
        this.origin = origin;
    }

    public Map<String, RasterDataSetBean> getDataSetMap() {
        return dataSetMap;
    }

    public void setDataSetMap(Map<String, RasterDataSetBean> dataSetMap) {
        this.dataSetMap = dataSetMap;
    }

    public LinkedHashMap<String, RasterLayerBean> getLayerMap() {
        return layerMap;
    }

    public void setLayerMap(LinkedHashMap<String, RasterLayerBean> layerMap) {
        this.layerMap = layerMap;
    }

    public Integer getBeginLevel() {
        return beginLevel;
    }

    public void setBeginLevel(Integer beginLevel) {
        this.beginLevel = beginLevel;
    }

    public Integer getEndLevel() {
        return endLevel;
    }

    public void setEndLevel(Integer endLevel) {
        this.endLevel = endLevel;
    }

    public CacheInfoBean getCacheInfo() {
        return cacheInfo;
    }

    public void setCacheInfo(CacheInfoBean cacheInfo) {
        this.cacheInfo = cacheInfo;
    }

    public STATE_TYPE getState() {
        return state;
    }

    public void setState(STATE_TYPE state) {
        this.state = state;
    }
    
    public SERVICE_TYPE getServiceType() {
        return serviceType;
    }
    
    public void setServiceType(SERVICE_TYPE serviceType) {
        this.serviceType = serviceType;
    }

    public String getBandValueToRGBAScript() {
        return bandValueToRGBAScript;
    }

    public void setBandValueToRGBAScript(String bandValueToRGBAScript) {
        this.bandValueToRGBAScript = bandValueToRGBAScript;
    }

    public String getMergeScript() {
        return mergeScript;
    }

    public void setMergeScript(String mergeScript) {
        this.mergeScript = mergeScript;
    }
}
