package com.northpool.service.config.texture;

import org.bson.Document;

import java.io.UnsupportedEncodingException;
import java.util.Base64;

public class TextureShell implements ITextureService {

    TextureBean texture;

    public TextureShell(TextureBean texture){
        this.texture = texture;
    }

    @Override
    public String getId() {
        return texture.getId();
    }

    @Override
    public String toJson() {
        return texture.toJson();
    }

    public TextureBean getTexture() {
        return texture;
    }

    public void setTexture(TextureBean texture) {
        this.texture = texture;
    }

    @Override
    public boolean isValid() {
        switch (texture.getType()){
            case png:
                break;
            case svg:
                String [] str = this.texture.getContent().split(",");
                try{
                    byte[] decodeContent = Base64.getDecoder().decode(str[1].getBytes("GBK"));
                    String keyStr = new String(new String(decodeContent, "GBK"));
                    if(keyStr.indexOf("<image") != -1) {
                        return false;
                    }
                }catch (UnsupportedEncodingException e){
                    e.printStackTrace();
                }


        }
        return true;
    }

    @Override
    public String getName() {
        return texture.getName();
    }

    @Override
    public TextureBean getBean() {
        return texture;
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    @Override
    public Document toDocument() {
        return texture.toDocument();
    }
}
