package com.northpool.service.config.vector_service.dataset;

import java.util.Map;

import com.northpool.resources.datatable.IField;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.spatial.Constants.GEO_TYPE;




public class DataSetShell  implements IDataSet  {
	
		
	protected DataSetBean dataSet;
	
	protected Client client;
	
	protected IDataService dataService;
	
	public DataSetShell(Client client, DataSetBean dataSet) {
		this.client = client;
		this.dataSet = dataSet;
		this.setDataService();
	}
	
	public void setDataService() {
	    if(this.dataService == null) {
	        String dataServiceId = this.dataSet.getDataServiceId();
	        this.dataService = this.client.getDataServiceManager().get(dataServiceId);
	        if(this.dataService == null) {
	            throw new RuntimeException(String.format("数据服务%s不存在", dataSet.getDataServiceId()));
	        }
	    }
	}


	@Override
	public String getFilter() {
		// TODO Auto-generated method stub
		return dataSet.getFilter();
	}

	@Override
	public String getSortFiled() {
		// TODO Auto-generated method stub
		return dataSet.getSortFiled();
	}

	@Override
	public String getSort() {
		// TODO Auto-generated method stub
		return dataSet.getSort();
	}

	@Override
	public String getSpatialFilter() {
		// TODO Auto-generated method stub
		return dataSet.getSpatialFilter();
	}

	@Override
	public Map<String, IField> getFieldsMap() {
		// TODO Auto-generated method stub
        if(this.dataService == null) {
            return null;
        }
        return this.dataService.getFieldMap();
	}

	@Override
	public String getIdField() {
		// TODO Auto-generated method stub
        if(this.dataService == null) {
            return null;
        }
		return this.dataService.getIdFieldName();
	}

	@Override
	public String getSpatialField() {
		// TODO Auto-generated method stub
        if(this.dataService == null) {
            return null;
        }
		return this.dataService.getSpatialFieldName();
	}

	@Override
	public GEO_TYPE getGeometryType() {
		// TODO Auto-generated method stub
        if(this.dataService == null) {
            return null;
        }
		return this.dataService.getGeoType();
	}

	@Override
	public IDataSourceInService getDataSource() {
		// TODO Auto-generated method stub
        if(this.dataService == null) {
            return null;
        }
		return this.dataService.getDataSource();
	}

	@Override
	public String[] getFieldsArr() {
		// TODO Auto-generated method stub
        if(this.dataService == null) {
            return null;
        }
		return this.dataService.getAliasFiledArr();
	}

    @Override
    public IDataService getDataService() {
        return this.dataService;
    }


	/**
	 * 获得fields的属性描述字段
	 * @return
	 */
	/*public String[] getFieldsPropertyGetterConfig() {
		IDataService dataService = dataServiceManager.get(this.dataServiceId);
		
		String[] fieldsWithoutSpatial = dataService.getFieldMap().entrySet().stream().filter(entry ->{
			IField field = entry.getValue();
			if(field.getFieldName().equalsIgnoreCase(dataService.getSpatialFieldName())){
				return false;
			}else{
				return true;
			}
		}).map(entry ->{
			return entry.getValue().getFieldName();
		}).toArray(String[]::new);
		return fieldsWithoutSpatial;
	}*/
	
	
	/*public List<Map<String,Object>> getFieldsPropertyGetterConfigMap() {
		if (this.fieldsPropertyGetterConfigMap == null) {
			synchronized (this) {
				if (this.fieldsPropertyGetterConfigMap != null) {
					return this.fieldsPropertyGetterConfigMap;
				}
				String[] fieldArr = this.fieldsWithoutShapeFieldArr;

				List<DBField> i = new ArrayList<DBField>();
				for (String field : fieldArr) {
					i.add(this.fieldsMap.get(field));
				}
				this.fieldsPropertyGetterConfigMap = this.getFieldsPropertyGetterConfigMap(i);
			}

		}
		return this.fieldsPropertyGetterConfigMap;
	}*/
	
	
	
	/*protected List<Map<String,Object>> getFieldsPropertyGetterConfigMap(List<DBField> configFields){
		List<Map<String,Object>> iList = new ArrayList<Map<String,Object>>();
		if (configFields.isEmpty()) {
			return null;
		}
		for (int i = 0; i < configFields.size(); i++) {
			DBField dbField = configFields.get(i);
			String fieldName = dbField.getFieldName();
			Map<String,Object> m = new HashMap<String,Object>();
			m.put("index", i);
			m.put("name", fieldName);
			m.put("type", String.valueOf(dbField.getType()));
			if (fieldName.equalsIgnoreCase(this.dbTable.getIdField())) {
				m.put("id", true);
			}
			iList.add(m);
		}
		return iList;
	}*/
	
	
	/*protected String getFieldsPropertyGetterConfig(List<DBField> configFields) {
		StringBuilder sb = new StringBuilder();
		if (configFields.isEmpty()) {
			return null;
		}
		this.jsonWriter.setPropertyName("fieldsConfig", sb);
		this.jsonWriter.arrayBegin(sb);
		for (int i = 0; i < configFields.size(); i++) {
			DBField dbField = configFields.get(i);
			String fieldName = dbField.getFieldName();
			this.jsonWriter.objectBegin(sb);
			this.jsonWriter.setPropertyName("index", sb);
			this.jsonWriter.setPropertyWraper(Integer.class, String.valueOf(i), sb);
			this.jsonWriter.propertyEnd(sb);
			this.jsonWriter.setPropertyName("name", sb);
			this.jsonWriter.setPropertyWraper(String.class, fieldName, sb);
			this.jsonWriter.propertyEnd(sb);
			this.jsonWriter.setPropertyName("type", sb);
			this.jsonWriter.setPropertyWraper(String.class, String.valueOf(dbField.getType()), sb);
			this.jsonWriter.propertyEnd(sb);
			if (fieldName.equalsIgnoreCase(this.dbTable.getIdField())) {
				this.jsonWriter.setPropertyName("id", sb);
				this.jsonWriter.setPropertyWraper(Boolean.class, "true", sb);
				this.jsonWriter.propertyEnd(sb);
			}

			this.jsonWriter.objectEnd(sb);
			this.jsonWriter.arrayNextElement(sb);
		}

		this.jsonWriter.arrayEnd(sb);
		return sb.toString();
	}*/

	
	

	
	
	
}
