package com.northpool.service.config.vector_service.utfgrid;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;

public class UtfgridInfoShell implements IUtfgridInfo {

    UtfgridInfoBean bean;

    IStorageInfo storageInfo;

    public UtfgridInfoShell(Client client, UtfgridInfoBean bean) {
        this.bean = bean;
        StorageInfoBean storageInfoBean = bean.getStorageInfo();
        if (storageInfoBean != null){
            this.storageInfo = new StorageInfoShell(client, storageInfoBean);
        }
    }

    @Override
    public IDataSourceInService getDataSource() {
        return this.storageInfo.getDataSource();
    }

    @Override
    public UtfgridInfoBean getBean() {
        return bean;
    }

    @Override
    public Integer getStartLevel() {
        return this.storageInfo.getStartLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.storageInfo.getEndLevel();
    }

    @Override
    public String getStorageName() {
        return this.storageInfo.getStorageName();
    }

    public Integer getSampling() {
        return this.bean.getSampling();
    }


    public String getMergeFields() {
        return this.bean.getMergeFields();
    }

    public Integer getPointSimplifyGridSize() {
        return this.bean.getPointSimplifyGridSize();
    }

    public Integer getPointSimplifyGird() {
        return this.bean.getPointSimplifyGird();
    }


    @Override
    public void drop() {
        if (this.storageInfo != null){
            this.storageInfo.drop();
        }
    }

    public IStorageInfo getStorageInfo() {
        return storageInfo;
    }

    public void setStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.bean.setStorageInfo(storageInfo.getBean());
    }
}
