package com.northpool.service.dao.texture;

import com.northpool.service.client.Client;
import com.northpool.service.config.texture.ITextureService;
import com.northpool.service.config.texture.TextureBean;
import com.northpool.service.config.texture.TextureShell;
import com.northpool.service.dao.AbstractIgniteDao;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import org.apache.ignite.Ignite;

public class TextureIgniteDao extends AbstractIgniteDao<TextureBean, ITextureService> {

    public TextureIgniteDao(String idFieldName, QueryHashTableHeap<String, ITextureService> table, Client client, String managerRoot, Boolean readOnly, Ignite ignite) {
        super(idFieldName, table, client, managerRoot, readOnly, ignite);
    }

    /*@Override
    protected void createCache() throws Exception {
        CacheConfiguration<String, StyleBean> cacheCfg = new CacheConfiguration<String, StyleBean>();
        cacheCfg.setName(this.managerRoot);
        cacheCfg.setCacheMode(CacheMode.REPLICATED);
        cacheCfg.setSqlSchema("PUBLIC");
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity queryEntity = new QueryEntity(String.class, StyleBean.class);
                *//*.addQueryField("uuid", String.class.getName(), null)
                .addQueryField("name", String.class.getName(), null)
                .addQueryField("ownServer", String.class.getName(), null)
                .addQueryField("styleJson", String.class.getName(), null)
                .addQueryField("textureLabel", String[].class.getName(), null)
                .addQueryField("textureLayer", String[].class.getName(), null)
                .addQueryField("extFonts", String[].class.getName(), null)
                .addQueryField("styleLayerJs", byte[].class.getName(), null)
                .addQueryField("styleLabelJs", byte[].class.getName(), null)
                .addQueryField("styleAvoidjs", byte[].class.getName(), null)
                .addQueryField("queryLayer", byte[].class.getName(), null)
                .addQueryField("queryLabel", byte[].class.getName(), null)
                .addQueryField("mapboxStyle", byte[].class.getName(), null)
                .addQueryField("version", String.class.getName(), null)
                .addQueryField("isTmp", Boolean.class.getName(), null)
                .addQueryField("xmin", Double.class.getName(), null)
                .addQueryField("ymin", Double.class.getName(), null)
                .addQueryField("xmax", Double.class.getName(), null)
                .addQueryField("ymax", Double.class.getName(), null);*//*


        Field[] declaredFields = StyleBean.class.getDeclaredFields();
        for (Field method : declaredFields) {
            queryEntity.addQueryField(method.getName(), method.getDeclaringClass().getName(), null);
        }

        queryEntity.setIndexes(Arrays.asList(new QueryIndex(this.idFieldName)));

        cacheCfg.setQueryEntities(Arrays.asList(queryEntity));

        IgniteCache<String, StyleBean> cache = ignite.createCache(cacheCfg);

        this.cache = cache;
    }*/

    @Override
    protected ITextureService getShell(TextureBean bean) {
        return new TextureShell(bean);
    }

}
