package com.northpool.service.manager;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;

import java.util.List;

/**
 * 元数据管理接口
 * @param <T> 元数据类型
 */
public interface IMetaDataManager<T> extends IClientManager {

    public T get(String id);

    public String getJSON(String id);

    List<T> findAll();

    public List<T> list(QueryFilter queryFilter);

    public IScroll<T> scroll(QueryFilter queryFilter);

    public T findOne(QueryFilter queryFilter);


}
