/**
　 * <p>Title: RasterDataServiceManager.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月01日
　 * @version 1.0
*//*

package com.northpool.service.manager.data_service.raster;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.data_service.raster.RasterDataServiceBuilder;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBuilder;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.dao.data_service.raster.RasterDataServiceMongoDao;
import com.northpool.service.dao.data_service.raster.RasterDataServiceZkDao;
import com.northpool.service.manager.abstractclass.InvalidException;
import com.northpool.service.manager.abstractclass.ServiceManager;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.vector_service.IVectorServiceManager;

*/
/**
 * @author chy
 *
 *//*

public class RasterDataServiceManager extends ServiceManager<IRasterDataService, RasterDataServiceBuilder> implements IRasterDataServiceManager {

    protected static final String MANAGER_ROOT = "raster_data_service";
    protected static final String MONGO_COLLECTION_NAME = "TAB_MAPENGINE_RASTERDATASERVICE_INFO";
    
    public RasterDataServiceManager() {
        super("id", new RasterDataServiceBuilder(), MANAGER_ROOT);
    }
    
    public void init() {
        super.init();
        this.beanBuilder.setClient(client);
        if (client.getZoo() != null) {
            this.zkDao = new RasterDataServiceZkDao(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
            this.zkDao.init();
            try {
                this.zkDao.syncFromZK();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mongoDao = new RasterDataServiceMongoDao(client.initMongoClient(), MONGO_COLLECTION_NAME, "id", beanBuilder);

    }
    
    @Override
    public void register(IRasterDataService dataService) throws ZKException {
        this.checkInvalid(dataService);
        
        super.doAdd(dataService);
    }
    
    */
/**
     * 检查影像数据服务中的文件是否全部存在
     * @param dataService
     * @throws InvalidException
     *//*

    protected void checkInvalid(IRasterDataService dataService) throws InvalidException{
        //TODO chy
    }

    @Override
    public void unRegister(String id) throws ZKException {
        super.doRemove(id);
    }

    @Override
    public void update(IRasterDataService dataService) throws ZKException {
        this.checkInvalid(dataService);

        //更新时，清空字段信息，重新获取
        //dataService.getBean().setImages(null);
//        dataService.getElements();
        
        super.doUpdate(dataService);

//        List<IRasterService> relatedServices = this.findRelatedVectorService(dataService);
//
//        this.updateRelatedVectorService(relatedServices);
        
    }
    
    private List<IVectorService> findRelatedVectorService(IRasterDataService dataService) {
        IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
        List<IVectorService> services = vectorServiceManager.list(new QueryFilter());
        List<IVectorService> relatedServices = services.stream().filter(service -> {
            Iterator<ILayer> it = service.getLayerMap().values().iterator();
            while (it.hasNext()){
                ILayer layer = it.next();
                Iterator<ILayerLevel> levelIterator = layer.getLevelMap().values().iterator();
                while (levelIterator.hasNext()){
                    ILayerLevel level = levelIterator.next();
                    if (dataService.getId().equals(level.getDataSet().getDataService().getId())){
                        return true;
                    }
                }
            }
            return false;
        }).collect(Collectors.toList());;
        return relatedServices;
    }
    
    private void updateRelatedVectorService(List<IVectorService> relatedServices) throws ZKException   {
        IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
        for(IVectorService service : relatedServices){
            IVectorService newService = new VectorServiceBuilder(service.getClient()).fromDataService(service.getId(), service.getDataServiceIds(), service.getOrigin(), service.getResolutions());
            if(service.getStorageInfo() != null){
                newService.addStorageInfo(service.getStorageInfo());
            }
            if(service.getUtfgridInfo() != null){
                newService.addUtfgridInfo(service.getUtfgridInfo());
            }
            if(service.getCacheInfo() != null){
                newService.addCacheInfo(service.getCacheInfo());
            }
            vectorServiceManager.update(newService);
        }
    }
    
    public IScroll<IRasterDataService> scroll(QueryFilter queryFilter) {
        return super.scroll(queryFilter);
    }
    
    public void start(String id) throws ZKException {
        super.start(id);
    }
    
    public void stop(String id) throws ZKException {
        super.stop(id);
    }
    
    public IRasterDataService get(String id) {
        return super.get(id);
    }
    
    public IRasterDataService findOne(QueryFilter queryFilter) {
        queryFilter.setStart(0);
        queryFilter.setLimit(1);
        List<IRasterDataService> iList = super.list(queryFilter);
        if(iList == null || iList.isEmpty()){
            return null;
        }else{
            return iList.get(0);
        }
    }
    
    @Override
    public void rename(String id, String newName) throws ZKException {
        IRasterDataService dataService = this.get(id);
        if (dataService == null) {
            throw new RuntimeException(StringUtils.join("栅格数据服务 ", id, " 不存在"));
        }
        dataService.getBean().setName(newName);

        IStorageInfo storageInfo = dataService.getStorageInfo();
        if(storageInfo != null){
            storageInfo.rename(dataService.getStorageName());
        }

//        List<IVectorService> relatedServices = this.findRelatedVectorService(dataService);

        this.doUpdate(dataService);

//        this.updateRelatedVectorService(relatedServices);
    }

}
*/
