package com.northpool.service.manager.font;


import com.northpool.service.config.Constants;
import com.northpool.service.config.font.IFontService;
import com.northpool.service.manager.abstractclass.IServiceManager;



public interface IFontManager extends IServiceManager<IFontService> {


    public void unRegister(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE filtType) throws  Exception;


    public void unRegisterByFamily(String family) throws Exception;

    /**
     * 获取字体树
     * @param idPatternStr 用于根据id模糊查询，可以为空
     * @param start
     * @param limit
     * @return
     */
    public String map(String idPatternStr, Integer start, Integer limit);

    public IFontService get(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, Constants.FONT_FILE_TYPE fileType);

    public String getJSON(String id);

    boolean checkVersion(String family, Constants.FONT_STYLE style, Constants.FONT_WEIGHT weight, String version, Constants.FONT_FILE_TYPE fileType);

    boolean checkVersion(String id, String version);

    public byte[] getContent(String id);


    /**
     * 获取后端默认字体 family
     * @return
     */
    public String getDefaultFont() throws Exception;


    /**
     * 获取前端生僻字 family
     * @return
     */
    public String getForeendUnCommon() throws Exception;


    /**
     * 获取后端生僻字 family
     * @return
     */
    public String getBackendUnCommon() throws Exception;


    public String getFontConfig() throws Exception;
}
