package com.northpool.service.manager.task;

import com.northpool.service.manager.IClientManager;
import com.northpool.service.manager.task.exception.TaskIsRunningException;
import com.northpool.service.manager.task.exception.TaskNotFoundException;

public interface ITaskManager  extends IClientManager {

    public void addTask(String taskId, ITileDispatchTask task);

    public void cancel(String taskId) throws TaskNotFoundException;

    public void remove(String taskId) ;

    public void setOrder(String taskId, int targetIndex) throws TaskIsRunningException, TaskNotFoundException;

    public boolean isBusy();

    public boolean isEnough(int size);

}
