package com.northpool.devtool.model;

import com.northpool.devtool.model.abstractclass.AbstractNetConnect;
import com.northpool.resources.utils.MongoClientURI;

import java.util.List;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/20/ 下午 5:06
 * @Description
 */
public class CacheMongoDbInfo extends AbstractNetConnect {

    String uri;
    String username;

    public CacheMongoDbInfo(String uri) {
        super(uri);
        this.uri = uri;
    }

    @Override
    public void init(String uri) {
        MongoClientURI clientURI = new MongoClientURI(uri);
        username = clientURI.getUsername();
        List<String> hosts = clientURI.getHosts();
        this.hosts = hosts;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}
