package com.northpool.devtool.model;

import com.sun.management.OperatingSystemMXBean;

import java.lang.management.ManagementFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/14/ 上午 11:46
 * @Description
 */
public class CpuInfo {
    final static long GB = 1024 * 1024 * 1024;

    //核心数
    Integer coreNum;
    //系统cpu使用率
    String systemUsage;
    //进程cpu使用率
    String processUsage;

    OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();

    public CpuInfo() {
        this.coreNum = operatingSystemMXBean.getAvailableProcessors();
    }

    public Integer getCoreNum() {
        return coreNum;
    }

    public String getSystemUsage() {
        return twoDecimal(operatingSystemMXBean.getSystemCpuLoad() * 100) + " %";
    }

    public String getProcessUsage() {
        return twoDecimal(operatingSystemMXBean.getProcessCpuLoad() * 100) + " %";
    }

    public static double twoDecimal(double doubleValue) {
        BigDecimal bigDecimal = new BigDecimal(doubleValue).setScale(2, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }
}
