package com.northpool.devtool.model.abstractclass;

import com.northpool.devtool.utils.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * @author Bai Chenguang
 * @Date: 2022/06/20/ 下午 5:13
 * @Description
 */
public abstract class AbstractNetConnect {
    private static Logger logger = LoggerFactory.getLogger(AbstractNetConnect.class);
    protected String ip;
    protected Integer port;
    protected List<String> hosts;
    protected Boolean isConnect = false;

    final Integer CONNECT_TIME_OUT = 1000;

    public AbstractNetConnect(String uri) {
        this.init(uri);
    }

    public abstract void init(String uri);

    public Boolean getConnect() {
        if (hosts != null && hosts.size() > 0) {
            Boolean flag = true;
            for (String item : hosts) {
                String[] host = item.split(":");
                String ip = host[0];
                int port = host.length == 1 ? 80 : Integer.parseInt(host[1]);
                if (!NetUtils.testIpAndPort(ip, port, CONNECT_TIME_OUT)) {
                    flag = false;
                    logger.error("连接不可用: {}:{}", ip, port);
                    break;
                }
            }
            return flag;
        }
        return NetUtils.testIpAndPort(ip, port, CONNECT_TIME_OUT);
    }

    public void setConnect(Boolean connect) {
        isConnect = connect;
    }
}

