package com.northpool.service.client;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import com.northpool.devtool.AbnormalCheck.MongoCheck;
import com.northpool.devtool.AbnormalCheck.ZookeeperCheck;
import com.northpool.resources.utils.MongoClientURI;
import com.northpool.service.manager.ManagerFactory;
import com.northpool.service.manager.cell.ITileDataCellManager;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_service.raster.IRasterDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.exception.ManagerDuplicateException;
import com.northpool.service.manager.exception.ManagerNotFoundException;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.service.manager.image_service.IImageServiceManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.task.ITaskManager;
import com.northpool.service.manager.terrain_service.ITerrainServiceManager;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.service.mapserver.MapServerAccess;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.*;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Collections;


public class Client {

	protected String zkAddress;

	protected CuratorFramework zkClient;

	protected Ignite ignite;

	protected MongoDatabase mongoDatabase = null;

	protected MapServerAccess mapServerAccess;

	protected Logger logger = LoggerFactory.getLogger("Client");

	public static String CMD_REQUEST = "/request";
	public static String CMD_RESPONSE = "/response";
	public static final String CMD_CREATE_TIME = "/time";

	public static final String ROOT = "/northpool_service_root";

	protected IDataSourcesManager dataSourcesManager;

	protected IDataServiceManager dataServiceManager;

	protected IVectorServiceManager vectorServiceManager;

	protected ITextureManager textureManager;

	protected IStyleManager styleManager;

	protected IFontManager fontManager;

	protected ITaskManager taskManager;

	protected ITileDataCellManager tileDataCellManager;

	private Integer httpMaxTotal = Runtime.getRuntime().availableProcessors();

    protected IRasterDataServiceManager rasterDataServiceManager;

    protected IImageServiceManager imageServiceManager;

    protected ITerrainServiceManager terrainServiceManager;

	static Client client;

	public Client(String zkAddress) throws Exception {
		this.zkAddress = zkAddress;
		this.zkClient = this.initZkClient(zkAddress);
		logger.info("zk正在连接");


		System.setProperty("javax.net.ssl.trustStore","mongo");
		System.setProperty("javax.net.ssl.trustStorePassword","changeit");
		System.setProperty("javax.net.ssl.keyStore","mongoclient");
		System.setProperty("javax.net.ssl.keyStorePassword","123456");

		this.initManager();
   	}
	   public static Client getInstance(String mongoUri, String zkAddress, String mapserverUrl) throws Exception {
			if (client == null){
				synchronized (Client.class){
					if (client == null){
						client = new Client(mongoUri, zkAddress, mapserverUrl);
					}
				}
			}
			return client;
	   }

   	/*public Client(String zkAddress, MongoConfig mongoConfig){
		this.zkAddress = zkAddress;
		this.zkClient = this.initZkClient(zkAddress);
		this.mongoDatabase = this.initMongoClient(mongoConfig);
		logger.info("zk正在连接");
		this.initManager();
	}

	public Client(String zkAddress, MongoConfig mongoConfig, String mapserverUrl){
		this.zkAddress = zkAddress;
		this.zkClient = this.initZkClient(zkAddress);
		this.mongoDatabase = this.initMongoClient(mongoConfig);
		MapServerAccess.setUrlPrifix(mapserverUrl);
		logger.info("zk正在连接");
		this.initManager();
	}

	public Client(MongoConfig mongoConfig, String mapserverUrl){
		this.mongoDatabase = this.initMongoClient(mongoConfig);
		MapServerAccess.setUrlPrifix(mapserverUrl);
		logger.info("zk正在连接");
		this.initManager();
	}*/

	public Client(String mongoUri, String zkAddress, String mapserverUrl) throws Exception {
		String trustStore = System.getenv("trustStore");
		String trustStorePassword = System.getenv("trustStorePassword");
		String keyStore = System.getenv("keyStore");
		String keyStorePassword = System.getenv("keyStorePassword");
		if (trustStore != null && trustStorePassword != null){
			System.setProperty("javax.net.ssl.trustStore", trustStore);
			System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
		}

		if (keyStore != null && keyStorePassword != null){
			System.setProperty("javax.net.ssl.keyStore", keyStore);
			System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
		}


		this.mongoDatabase = this.initMongoClient(mongoUri);
		if (StringUtils.isNoneEmpty(zkAddress)){
			this.zkAddress = zkAddress;
			this.zkClient = this.initZkClient(zkAddress);
		}

		if(StringUtils.isNoneEmpty(mapserverUrl)){
			MapServerAccess.setUrlPrifix(mapserverUrl);
		}

		//ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("conf/app-context.xml");
		//AppUtil.appContext = ctx;

		this.initManager();
	}


	public Client(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp, String mapserverUrl) throws Exception {


		this.initIgniteByMultiCastMode(igniteAddress, igniteClientPort, igniteMcastGrp);

		if(StringUtils.isNoneEmpty(mapserverUrl)){
			MapServerAccess.setUrlPrifix(mapserverUrl);
		}

		//ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("conf/app-context.xml");
		//AppUtil.appContext = ctx;

		this.initManager();
	}

	private void initIgniteByMultiCastMode(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp){
/*		if (StringUtils.isEmpty(igniteAddress)){
			igniteAddress = "127.0.0.1:47500..47509";
		}*/


		IgniteConfiguration cfg = new IgniteConfiguration();
		String property = System.getProperty("user.dir");
		cfg.setWorkDirectory(property + File.separator + "ignitedb");

		// The node will be started as a client node.
		cfg.setClientMode(false);
		cfg.setPeerClassLoadingEnabled(true);

		//data storage configuration
		DataStorageConfiguration storageCfg = new DataStorageConfiguration();

		DataRegionConfiguration defaultDataRegionConfiguration = storageCfg.getDefaultDataRegionConfiguration();

		defaultDataRegionConfiguration.setPersistenceEnabled(true);
		defaultDataRegionConfiguration.setMaxSize(50 * 1024 * 1024);

		defaultDataRegionConfiguration.setPageReplacementMode(PageReplacementMode.SEGMENTED_LRU);
		defaultDataRegionConfiguration.setPageEvictionMode(DataPageEvictionMode.RANDOM_LRU);

		cfg.setDataStorageConfiguration(storageCfg);
		// Setting up an IP Finder to ensure the client can locate the servers.
		TcpDiscoveryMulticastIpFinder ipFinder = new TcpDiscoveryMulticastIpFinder();
		if (StringUtils.isNotEmpty(igniteAddress)){
			ipFinder.setAddresses(Collections.singletonList(igniteAddress));
		}

		if (StringUtils.isNotEmpty(igniteMcastGrp)){
			ipFinder.setMulticastGroup(igniteMcastGrp);
		}
		cfg.setDiscoverySpi(new TcpDiscoverySpi().setIpFinder(ipFinder));


		if (igniteClientPort != null){
			ClientConnectorConfiguration clientConnectorCfg = new ClientConnectorConfiguration();
			clientConnectorCfg.setPort(igniteClientPort);
			clientConnectorCfg.setPortRange(0);
			cfg.setClientConnectorConfiguration(clientConnectorCfg);
		}
		// Starting the node
		this.ignite = Ignition.start(cfg);
		this.ignite.cluster().state(ClusterState.ACTIVE);
		this.ignite.cluster().setBaselineTopology(ignite.cluster().forServers().nodes());

		//ignite.resetLostPartitions(Arrays.asList("data_sources", "data_service", "vector_service", "style", "texture", "font"));
		ignite.resetLostPartitions(ignite.cacheNames());


	}

/*	public Client(String mongoIp, Integer mongoPort, String mongoUser, String mongoPassword, String mongoNamespace, String zkAddress, String mapserverUrl){
		this.mongoDatabase = this.initMongoClient(mongoIp, mongoPort, mongoUser, mongoPassword, mongoNamespace);
		if (StringUtils.isNoneEmpty(zkAddress)){
			this.zkAddress = zkAddress;
			this.zkClient = this.initZkClient(zkAddress);
		}

		if(StringUtils.isNoneEmpty(mapserverUrl)){
			MapServerAccess.setUrlPrifix(mapserverUrl);
		}

		ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("conf/app-context.xml");
		AppUtil.appContext = ctx;

		this.initManager();
	}
	*/
	public void initManager() throws Exception {
		try {
			ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
			this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
		//	System.out.println("this.dataSourcesManager " + this.dataSourcesManager);
			this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
//			this.rasterDataServiceManager = ManagerFactory.getManager(IRasterDataServiceManager.class, this);
			this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
//			this.imageServiceManager = ManagerFactory.getManager(IImageServiceManager.class, this);
//			this.terrainServiceManager = ManagerFactory.getManager(ITerrainServiceManager.class, this);
			this.textureManager = ManagerFactory.getManager(ITextureManager.class, this);
			this.styleManager = ManagerFactory.getManager(IStyleManager.class, this);
			this.fontManager = ManagerFactory.getManager(IFontManager.class, this);
			this.tileDataCellManager = ManagerFactory.getManager(ITileDataCellManager.class, this);

		} catch (ManagerDuplicateException e) {
			this.logger.error(e.getMessage(),e);
			throw new RuntimeException(e);
		} catch (ManagerNotFoundException e) {
			this.logger.error(e.getMessage(),e);
			throw new RuntimeException(e);
		}

	}

	private synchronized CuratorFramework initZkClient(String zkAddress){
		ZookeeperCheck.getInst(zkAddress).check();
		CuratorFramework client = CuratorFrameworkFactory.newClient(
				zkAddress,
				new RetryNTimes(10, 5000)
		);
		client.start();
		return client;
	}

/*	private synchronized MongoDatabase initMongoClient(MongoConfig mongoConfig){
		if (StringUtils.isNotEmpty(mongoConfig.getUri())){
			return initMongoClient(mongoConfig.getUri());
		}

		String ip = mongoConfig.getIp();
		int port = mongoConfig.getPort();
		String userName = mongoConfig.getUserName();
		String password = mongoConfig.getPassword();
		String databaseName = mongoConfig.getDatabaseName();

		return initMongoClient(ip, port, userName, password, databaseName);
	}*/

	public MongoDatabase initMongoClient(String uri) {
		MongoCheck.getInst(uri).check();
		MongoClient mongoClient;
/*		MongoClientOptions.Builder buide = new MongoClientOptions.Builder();
		buide.connectionsPerHost(20);// 与目标数据库可以建立的最大链接数
		buide.connectTimeout(1000 * 60 * 20);// 与数据库建立链接的超时时间
		buide.maxWaitTime(100 * 60 * 5 * 100);// 一个线程成功获取到一个可用数据库之前的最大等待时间
		buide.threadsAllowedToBlockForConnectionMultiplier(100);
		buide.maxConnectionIdleTime(0);
		buide.maxConnectionLifeTime(0);
		buide.socketTimeout(0);
		buide.socketKeepAlive(true);*/
		MongoClientURI mongoClientURI = new MongoClientURI(uri);
		try {
			mongoClient = MongoClients.create(uri);
		} catch (Exception e) {
			e.printStackTrace();
			throw new RuntimeException(e.getMessage());
		}
		return mongoClient.getDatabase(mongoClientURI.getDatabase());
	}


	public CuratorFramework getZoo(){
		return this.zkClient;
	}


	public IVectorServiceManager getVectorServiceManager(){
		return this.vectorServiceManager;
	}


	public IDataSourcesManager getDataSourcesManager(){
		return this.dataSourcesManager;
	}

	public IDataServiceManager getDataServiceManager(){
		return this.dataServiceManager;
	}

	public IRasterDataServiceManager getRasterDataServiceManager() {
        return this.rasterDataServiceManager;
    }

	public IImageServiceManager getImageServiceManager() {
	    return this.imageServiceManager;
	}

	public ITerrainServiceManager getTerrainServiceManager() {
	    return this.terrainServiceManager;
	}

    public ITextureManager getTextureManager(){
		return this.textureManager;
	}

	public IStyleManager getStyleManager() {
		return styleManager;
	}

	public IFontManager getFontManager() {
		return fontManager;
	}

	public ITaskManager getTaskManager() {
		return taskManager;
	}

	public ITileDataCellManager getTileDataCellManager() {
		return tileDataCellManager;
	}

	public String getZkAddress() {
		return zkAddress;
	}

	public void setZkAddress(String zkAddress) {
		this.zkAddress = zkAddress;
	}

	public MongoDatabase initMongoClient() {
		return mongoDatabase;
	}

	public void setMongoDatabase(MongoDatabase mongoDatabase) {
		this.mongoDatabase = mongoDatabase;
	}

	public MapServerAccess getMapServerAccess() {
		return new MapServerAccess(httpMaxTotal, 180 * 1000);
	}

	public void setMapServerAccess(MapServerAccess mapServerAccess) {
		this.mapServerAccess = mapServerAccess;
	}

	public Ignite getIgnite() {
		return ignite;
	}
}
