/**
　 * <p>Title: RasterLayerLevelShell.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2021</p>
　 * <p>Company: northpool</p>
　 * @author chy
　 * @date 2021年12月22日
　 * @version 1.0
*/
package com.northpool.service.config.raster_service.layer;

import java.util.Map;

import com.northpool.service.client.Client;
import com.northpool.service.config.raster_service.dataset.IRasterDataSet;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.dataset.RasterDataSetShell;

/**
 * @author chy
 *
 */
public class RasterLayerLevelShell implements IRasterLayerLevel {

    private RasterLayerLevelBean layerLevel;
    
//    private Client client;
    
    private IRasterDataSet dataSet;
    
    public RasterLayerLevelShell(Client client, RasterLayerLevelBean layerLevel,
            Map<String, RasterDataSetBean> dataSetHashMap) {
//        this.client = client;
        this.layerLevel = layerLevel;
        
        //创建IDataSet
        String dataSetId = layerLevel.getDataSetId();
        RasterDataSetBean dataSet = dataSetHashMap.get(dataSetId);
        if(dataSet == null) {
            throw new RuntimeException(String.format("没有找到dataset%s", dataSetId));
        }
        this.dataSet = this.createDataSet(client, dataSet);
    }
    
    private IRasterDataSet createDataSet(Client client, RasterDataSetBean dataSet){
        return new RasterDataSetShell(client, dataSet);
    }
    
    @Override
    public Integer getLevel() {
        return this.layerLevel.getLevel();
    }

    @Override
    public IRasterDataSet getDataSet() {
        return this.dataSet;
    }

}
